/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.hosted;

import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AptHostedFacet;
import org.sonatype.nexus.repository.apt.internal.AptFacetHelper;
import org.sonatype.nexus.repository.apt.internal.AptPackageParser;
import org.sonatype.nexus.repository.apt.internal.debian.ControlFile;
import org.sonatype.nexus.repository.apt.internal.debian.PackageInfo;
import org.sonatype.nexus.repository.apt.internal.snapshot.AptSnapshotHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named
@Singleton
public class AptHostedHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String path = this.assetPath(context);
        String method = context.getRequest().getAction();
        AptContentFacet contentFacet = (AptContentFacet)context.getRepository().facet(AptContentFacet.class);
        switch (method) {
            case "GET": 
            case "HEAD": {
                return this.doGet(context, path, contentFacet);
            }
            case "POST": {
                return this.doPost(context, path, contentFacet);
            }
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"GET", "HEAD", "POST"});
    }

    private Response doGet(Context context, String path, AptContentFacet contentFacet) throws IOException {
        Optional<Content> content;
        if (this.isMetadataRebuildRequired(path, contentFacet)) {
            ((AptHostedFacet)context.getRepository().facet(AptHostedFacet.class)).rebuildMetadata();
        }
        return (content = contentFacet.get(path)).isPresent() ? HttpResponses.ok((Payload)((Payload)content.get())) : HttpResponses.notFound((String)path);
    }

    private Response doPost(Context context, String path, AptContentFacet contentFacet) throws IOException {
        AptHostedFacet hostedFacet = (AptHostedFacet)context.getRepository().facet(AptHostedFacet.class);
        if ("rebuild-indexes".equals(path)) {
            hostedFacet.rebuildMetadata();
            return HttpResponses.ok();
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            Payload payload = context.getRequest().getPayload();
            Throwable throwable = null;
            Object var7_8 = null;
            try (TempBlob tempBlob = contentFacet.getTempBlob(payload);){
                ControlFile controlFile = AptPackageParser.parsePackageInfo((InputStreamSupplier)tempBlob).getControlFile();
                String assetPath = AptFacetHelper.buildAssetPath(controlFile);
                long payloadSize = payload.getSize();
                String contentType = payload.getContentType();
                hostedFacet.put(assetPath, (Payload)new StreamPayload((InputStreamSupplier)tempBlob, payloadSize, contentType), new PackageInfo(controlFile));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return HttpResponses.created();
        }
        return HttpResponses.methodNotAllowed((String)"POST", (String[])new String[]{"GET", "HEAD"});
    }

    private boolean isMetadataRebuildRequired(String path, AptContentFacet contentFacet) {
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"dists") && StringUtils.endsWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{"InRelease", "Release", "Release.gpg", "/Packages"})) {
            String inReleasePath = "dists/" + contentFacet.getDistribution() + "/" + "InRelease";
            return !contentFacet.get(inReleasePath).isPresent();
        }
        return false;
    }

    private String assetPath(Context context) {
        return ((AptSnapshotHandler.State)context.getAttributes().require(AptSnapshotHandler.State.class)).assetPath;
    }
}

