/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.hosted;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.AssetChange;
import org.sonatype.nexus.repository.apt.datastore.internal.hosted.metadata.AptHostedMetadataFacet;
import org.sonatype.nexus.repository.apt.internal.debian.PackageInfo;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Payload;

@Named
@Facet.Exposed
public class AptHostedFacet
extends FacetSupport {
    public FluentAsset put(String assetPath, Payload payload, PackageInfo packageInfo) throws IOException {
        Preconditions.checkNotNull((Object)assetPath);
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)packageInfo);
        FluentAsset asset = this.content().put(assetPath, payload, packageInfo);
        this.metadata().addPackageMetadata(asset);
        this.metadata().removeInReleaseIndex();
        return asset;
    }

    private AptContentFacet content() {
        return (AptContentFacet)this.facet(AptContentFacet.class);
    }

    private AptHostedMetadataFacet metadata() {
        return (AptHostedMetadataFacet)this.facet(AptHostedMetadataFacet.class);
    }

    public void rebuildMetadata() throws IOException {
        this.rebuildMetadata(Collections.emptyList());
    }

    public void rebuildMetadata(List<AssetChange> changeList) throws IOException {
        this.metadata().rebuildMetadata(changeList);
    }
}

