/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.data;

import com.google.common.base.Preconditions;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.apt.datastore.data.AptKeyValueDAO;
import org.sonatype.nexus.repository.apt.datastore.data.AptKeyValueStore;
import org.sonatype.nexus.repository.content.kv.KeyValue;
import org.sonatype.nexus.repository.content.kv.KeyValueFacetSupport;

@Named(value="apt")
@Facet.Exposed
public class AptKeyValueFacet
extends KeyValueFacetSupport<AptKeyValueDAO, AptKeyValueStore> {
    private final int limit;
    private static final String CATEGORY = "";

    @Inject
    public AptKeyValueFacet(@Named(value="${nexus.apt.paging.size:-100}") @Named(value="${nexus.apt.paging.size:-100}") int limit) {
        super("apt", AptKeyValueDAO.class);
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0);
        this.limit = limit;
    }

    public void addPackageMetadata(int componentId, int assetId, String metadata) {
        this.set(CATEGORY, this.aptKey(componentId, assetId), metadata);
    }

    public void removePackageMetadata(int componentId, int assetId) {
        this.remove(CATEGORY, this.aptKey(componentId, assetId));
    }

    public void removeAllPackageMetadata() {
        this.removeAll(CATEGORY);
    }

    public Stream<String> browsePackagesMetadata() {
        return Continuations.streamOf((browseLimit, continuationToken) -> this.browseValues(CATEGORY, (int)browseLimit, (String)continuationToken), (int)this.limit).map(KeyValue::getValue);
    }

    private String aptKey(int componentId, int assetId) {
        return "apt-" + componentId + '-' + assetId;
    }
}

