/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.datastore.internal.browse;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.browse.node.BrowsePathBuilder;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.browse.DefaultBrowseNodeGenerator;

@Named(value="apt")
@Singleton
public class AptBrowseNodeGenerator
extends DefaultBrowseNodeGenerator {
    private static final String PACKAGES_PATH = "packages";
    private static final String METADATA_PATH = "metadata";

    public List<BrowsePath> computeAssetPaths(Asset asset) {
        Component component = asset.component().orElse(null);
        if (component != null) {
            List<BrowsePath> path = this.computeComponentPaths(asset);
            BrowsePathBuilder.appendPath(path, (String)asset.path().substring(1));
            return path;
        }
        ArrayList<String> pathParts = new ArrayList<String>();
        String path = asset.path();
        if (path.endsWith(".deb") || path.endsWith(".udeb")) {
            pathParts.add(PACKAGES_PATH);
        } else if (!path.startsWith("/snapshots")) {
            pathParts.add(METADATA_PATH);
        }
        pathParts.addAll(Splitter.on((String)"/").omitEmptyStrings().splitToList((CharSequence)path));
        return BrowsePathBuilder.fromPaths(pathParts, (boolean)true);
    }

    public List<BrowsePath> computeComponentPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkArgument((boolean)asset.component().isPresent());
        Component component = (Component)asset.component().get();
        ArrayList<String> pathParts = new ArrayList<String>();
        pathParts.add(PACKAGES_PATH);
        pathParts.add(component.name().substring(0, 1).toLowerCase());
        pathParts.add(component.name());
        pathParts.add(component.version());
        pathParts.add(component.namespace());
        pathParts.add(component.name());
        return BrowsePathBuilder.fromPaths(pathParts, (boolean)true);
    }
}

