/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.apt.api;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.apt.api.AptHostedApiRepository;
import org.sonatype.nexus.repository.apt.api.AptHostedRepositoriesAttributes;
import org.sonatype.nexus.repository.apt.api.AptProxyApiRepository;
import org.sonatype.nexus.repository.apt.api.AptProxyRepositoriesAttributes;
import org.sonatype.nexus.repository.apt.api.AptSigningRepositoriesAttributes;
import org.sonatype.nexus.repository.rest.api.SimpleApiRepositoryAdapter;
import org.sonatype.nexus.repository.rest.api.model.AbstractApiRepository;
import org.sonatype.nexus.repository.rest.api.model.StorageAttributes;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named(value="apt")
public class AptApiRepositoryAdapter
extends SimpleApiRepositoryAdapter {
    @Inject
    public AptApiRepositoryAdapter(RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
    }

    public AbstractApiRepository adapt(Repository repository) {
        boolean online = repository.getConfiguration().isOnline();
        String name = repository.getName();
        String url = repository.getUrl();
        switch (repository.getType().toString()) {
            case "hosted": {
                return new AptHostedApiRepository(name, url, online, this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.createAptHostedRepositoriesAttributes(repository), this.createAptSigningRepositoriesAttributes(repository), this.getComponentAttributes(repository));
            }
            case "proxy": {
                return new AptProxyApiRepository(name, url, online, (StorageAttributes)this.getHostedStorageAttributes(repository), this.getCleanupPolicyAttributes(repository), this.createAptProxyRepositoriesAttributes(repository), this.getProxyAttributes(repository), this.getNegativeCacheAttributes(repository), this.getHttpClientAttributes(repository), this.getRoutingRuleName(repository), this.getReplicationAttributes(repository));
            }
        }
        return null;
    }

    private AptHostedRepositoriesAttributes createAptHostedRepositoriesAttributes(Repository repository) {
        String distribution = (String)repository.getConfiguration().attributes("apt").get("distribution", String.class);
        return new AptHostedRepositoriesAttributes(distribution);
    }

    private AptSigningRepositoriesAttributes createAptSigningRepositoriesAttributes(Repository repository) {
        NestedAttributesMap aptAttributes = repository.getConfiguration().attributes("aptSigning");
        String keypair = (String)aptAttributes.get("keypair", String.class);
        String passphrase = (String)aptAttributes.get("passphrase", String.class);
        if (!Strings2.isBlank((String)passphrase)) {
            return new AptSigningRepositoriesAttributes(keypair, null);
        }
        return null;
    }

    private AptProxyRepositoriesAttributes createAptProxyRepositoriesAttributes(Repository repository) {
        NestedAttributesMap aptAttributes = repository.getConfiguration().attributes("apt");
        String distribution = (String)aptAttributes.get("distribution", String.class);
        Boolean flat = (Boolean)aptAttributes.get("flat", Boolean.class);
        return new AptProxyRepositoriesAttributes(distribution, flat);
    }
}

