/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.apt.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.util.StringUtils;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.apt.internal.orient.AptRestoreBlobData;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.apt.orient.AptRestoreFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;

@Named(value="apt")
@Singleton
public class OrientAptRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<AptRestoreBlobData> {
    @Inject
    public OrientAptRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, DryRunPrefix dryRunPrefix) {
        super(nodeAccess, repositoryManager, dryRunPrefix);
    }

    public AptRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        Preconditions.checkState((!StringUtils.isEmpty((String)blobData.getBlobName()) ? 1 : 0) != 0, (Object)"Blob name cannot be empty");
        return new AptRestoreBlobData(blobData);
    }

    protected boolean canAttemptRestore(@Nonnull AptRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        Optional aptRestoreFacetFacet = repository.optionalFacet(AptRestoreFacet.class);
        if (!aptRestoreFacetFacet.isPresent()) {
            this.log.warn("Skipping as APT Restore Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    public String getAssetPath(@Nonnull AptRestoreBlobData data) {
        return data.getBlobData().getBlobName();
    }

    protected boolean assetExists(@Nonnull AptRestoreBlobData data) {
        AptRestoreFacet facet = (AptRestoreFacet)data.getBlobData().getRepository().facet(AptRestoreFacet.class);
        return facet.assetExists(data.getBlobData().getBlobName());
    }

    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull AptRestoreBlobData data) throws IOException {
        Repository repository = data.getBlobData().getRepository();
        AptRestoreFacet facet = (AptRestoreFacet)repository.facet(AptRestoreFacet.class);
        String path = data.getBlobData().getBlobName();
        facet.restore(assetBlob, path);
    }

    public boolean componentRequired(AptRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        AptRestoreFacet facet = (AptRestoreFacet)repository.facet(AptRestoreFacet.class);
        return facet.componentRequired(data.getBlobData().getBlobName());
    }

    protected Repository getRepository(@Nonnull AptRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }

    protected Query getComponentQuery(AptRestoreBlobData data) throws IOException {
        Repository repository = data.getBlobData().getRepository();
        AptRestoreFacet facet = (AptRestoreFacet)repository.facet(AptRestoreFacet.class);
        return facet.getComponentQuery(data.getBlobData().getBlob());
    }

    @Nonnull
    public List<HashAlgorithm> getHashAlgorithms() {
        return Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.MD5, HashAlgorithm.SHA1, HashAlgorithm.SHA256});
    }
}

