/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.apt.internal;

import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.DataStoreRestoreBlobData;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.apt.datastore.AptContentFacet;
import org.sonatype.nexus.repository.apt.debian.Utils;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="apt")
@Singleton
public class AptRestoreBlobStrategy
extends BaseRestoreBlobStrategy<DataStoreRestoreBlobData> {
    private final RepositoryManager repositoryManager;

    @Inject
    public AptRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager) {
        super(dryRunPrefix);
        this.repositoryManager = repositoryManager;
    }

    protected boolean canAttemptRestore(@Nonnull DataStoreRestoreBlobData data) {
        Repository repository = data.getRepository();
        Optional facet = repository.optionalFacet(AptContentFacet.class);
        if (!facet.isPresent()) {
            this.log.warn("Skipping as {} not found on repository: {}", (Object)facet.getClass().getSimpleName(), (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected void createAssetFromBlob(Blob assetBlob, DataStoreRestoreBlobData data) throws IOException {
        String assetPath = this.getAssetPath(data);
        DetachedBlobPayload payload = new DetachedBlobPayload(assetBlob);
        ((AptContentFacet)data.getRepository().facet(AptContentFacet.class)).put(assetPath, (Payload)payload);
    }

    protected String getAssetPath(@Nonnull DataStoreRestoreBlobData data) {
        return data.getBlobName();
    }

    protected DataStoreRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new DataStoreRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected boolean isComponentRequired(DataStoreRestoreBlobData data) {
        String blobName = data.getBlobName();
        return Utils.isDebPackageContentType(blobName);
    }

    public void after(boolean updateAssets, Repository repository) {
    }
}

