/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ossindex.rapture;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.repository.ossindex.VulnerabilityReportXO;
import org.sonatype.nexus.repository.ossindex.VulnerabilityService;

@Named
@Singleton
@DirectAction(action={"coreui_Vulnerability"})
public class VulnerabilityComponent
extends DirectComponentSupport {
    private Provider<VulnerabilityService> vulnerabilityServiceProvider;

    @Inject
    public VulnerabilityComponent(Provider<VulnerabilityService> vulnerabilityServiceProvider) {
        this.vulnerabilityServiceProvider = vulnerabilityServiceProvider;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Nullable
    public Map<PackageUrl, VulnerabilityReportXO> read(List<String> packageUrls) {
        VulnerabilityService vulnerabilityService = (VulnerabilityService)this.vulnerabilityServiceProvider.get();
        if (vulnerabilityService == null || !vulnerabilityService.isEnabled()) {
            return Collections.emptyMap();
        }
        try {
            List coordinates = packageUrls.stream().filter(StringUtils::isNotEmpty).map(PackageUrl::parse).collect(Collectors.toList());
            if (coordinates.isEmpty()) {
                return Collections.emptyMap();
            }
            return vulnerabilityService.getVulnerabilityReport(coordinates).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::withSourceParam));
        }
        catch (Exception e) {
            this.log.warn("Failed to fetch vulnerability report", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private VulnerabilityReportXO withSourceParam(Map.Entry<PackageUrl, VulnerabilityReportXO> e) {
        VulnerabilityReportXO reportXO = e.getValue();
        reportXO.setReference(String.valueOf(reportXO.getReference()) + "?ossindex_src=nxrm");
        return reportXO;
    }
}

