/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ossindex.internal.service;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.ossindex.internal.client.VulnerabilityClient;
import org.sonatype.nexus.ossindex.internal.client.VulnerabilityReport;
import org.sonatype.nexus.repository.ossindex.VulnerabilityReportXO;
import org.sonatype.nexus.repository.ossindex.VulnerabilityService;

@Named
@Singleton
public class VulnerabilityServiceImpl
extends ComponentSupport
implements VulnerabilityService,
EventAware {
    private static final CapabilityType CLM_CAPABILITY_TYPE = CapabilityType.capabilityType((String)"clm");
    private VulnerabilityClient vulnerabilityClient;
    private final ApplicationVersion applicationVersion;
    private volatile boolean clmEnabled = false;

    @Inject
    VulnerabilityServiceImpl(VulnerabilityClient vulnerabilityClient, ApplicationVersion applicationVersion) {
        this.applicationVersion = applicationVersion;
        this.vulnerabilityClient = vulnerabilityClient;
    }

    public boolean isEnabled() {
        return !this.clmEnabled && "OSS".equals(this.applicationVersion.getEdition());
    }

    public Map<PackageUrl, VulnerabilityReportXO> getVulnerabilityReport(List<PackageUrl> coordinates) {
        return this.vulnerabilityClient.requestVulnerabilityReport(coordinates).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toReportXO((VulnerabilityReport)e.getValue())));
    }

    private VulnerabilityReportXO toReportXO(VulnerabilityReport r) {
        return new VulnerabilityReportXO(r.getDescription(), r.getReference(), r.getCount());
    }

    @AllowConcurrentEvents
    @Subscribe
    void on(CapabilityEvent.AfterActivated event) {
        if (CLM_CAPABILITY_TYPE.equals((Object)event.getReference().context().type())) {
            this.clmEnabled = true;
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    void on(CapabilityEvent.BeforePassivated event) {
        if (CLM_CAPABILITY_TYPE.equals((Object)event.getReference().context().type())) {
            this.clmEnabled = false;
        }
    }
}

