/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.api.cvss;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.ossindex.service.api.cvss.CvssMetric;

public abstract class CvssVector {
    private static final Logger log = LoggerFactory.getLogger(CvssVector.class);
    private final String version;
    private final String value;
    private final Map<String, String> metrics;
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/').trimResults();
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').trimResults();

    public CvssVector(String version, String value) {
        this.version = (String)Preconditions.checkNotNull((Object)version);
        this.value = (String)Preconditions.checkNotNull((Object)value);
        this.metrics = Collections.unmodifiableMap(this.parse(value));
    }

    public String getVersion() {
        return this.version;
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getMetrics() {
        return this.metrics;
    }

    private Map<String, String> parse(String value) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String metric : SLASH_SPLITTER.split((CharSequence)value)) {
            List parts = COLON_SPLITTER.splitToList((CharSequence)metric);
            result.put((String)parts.get(0), (String)parts.get(1));
        }
        return result;
    }

    public List<MetricDescription> getDescriptions() {
        LinkedList<MetricDescription> result = new LinkedList<MetricDescription>();
        for (Map.Entry<String, String> entry : this.metrics.entrySet()) {
            String metric = entry.getKey();
            result.add(this.describe(metric, entry.getValue()));
        }
        return result;
    }

    @Nullable
    protected abstract CvssMetric findMetric(String var1);

    protected MetricDescription describe(String metricCode, String metricValue) {
        String group = "unknown";
        String title = metricCode;
        String meaning = metricValue;
        CvssMetric metric = this.findMetric(metricCode);
        if (metric != null) {
            group = metric.getGroup();
            title = metric.getTitle();
            meaning = metric.getMeaning(metricValue);
            if (meaning == null) {
                meaning = metricValue;
            }
        }
        if (metricCode.equals(title) || metricValue.equals(meaning)) {
            log.warn("Did not translate; metric: {} -> {}; meaning: {} -> {}", new Object[]{metricCode, title, metricValue, meaning});
        }
        return new MetricDescription(metricCode, group, title, metricValue, meaning);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.version).add("value", (Object)this.value).add("metrics", this.metrics).toString();
    }

    protected static Map<String, CvssMetric> createLookup(CvssMetric[] metrics) {
        HashMap<String, CvssMetric> lookup = new HashMap<String, CvssMetric>(metrics.length);
        CvssMetric[] cvssMetricArray = metrics;
        int n = metrics.length;
        int n2 = 0;
        while (n2 < n) {
            CvssMetric metric = cvssMetricArray[n2];
            CvssMetric prev = lookup.put(metric.getCode(), metric);
            if (prev != null) {
                log.warn("Duplicate metric code: {}", (Object)metric.getCode());
            }
            ++n2;
        }
        return Collections.unmodifiableMap(lookup);
    }

    public static class MetricDescription {
        private final String code;
        private final String group;
        private final String title;
        private final String valueCode;
        private final String value;

        public MetricDescription(String code, String group, String title, String valueCode, String value) {
            this.code = code;
            this.group = group;
            this.title = title;
            this.valueCode = valueCode;
            this.value = value;
        }

        public String getCode() {
            return this.code;
        }

        public String getGroup() {
            return this.group;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDisplayTitle() {
            if (this.title.equals(this.code)) {
                return this.title;
            }
            return String.format("%s (%s)", this.title, this.code);
        }

        public String getValueCode() {
            return this.valueCode;
        }

        public String getValue() {
            return this.value;
        }

        public String getDisplayValue() {
            if (this.value.equals(this.valueCode)) {
                return this.value;
            }
            return String.format("%s (%s)", this.value, this.valueCode);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("code", (Object)this.code).add("group", (Object)this.group).add("title", (Object)this.title).add("valueCode", (Object)this.valueCode).add("value", (Object)this.value).toString();
        }
    }
}

