/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task.datastore;

import com.sonatype.insight.scan.anon.Anonymizer;
import com.sonatype.insight.scan.client.ClientScanner;
import com.sonatype.nexus.plugins.healthcheck.service.NexusIDService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckProcessorSupport;
import java.time.Instant;
import java.time.OffsetDateTime;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.types.ProxyType;

@Named
public class HealthCheckProcessor
extends HealthCheckProcessorSupport {
    private HealthCheckProcessorSupport.HealthCheckItemExtractor<FluentAsset> extractor = new HealthCheckProcessorSupport.HealthCheckItemExtractor<FluentAsset>(HealthCheckAssetImpl::new);

    @Inject
    HealthCheckProcessor(Anonymizer anonymizer, ClientScanner clientScanner, NexusIDService idService, ProxyType proxyType, @Named(value="maven2") @Named(value="maven2") Format maven2Format) {
        super(anonymizer, clientScanner, idService, proxyType, maven2Format);
    }

    public void processAsset(Repository repository, FluentAsset asset) throws Exception {
        this.processAsset(repository, () -> this.extractor.extract(asset, repository, this.maven2Format.equals((Object)repository.getFormat())));
    }

    public void setHealthCheckItemExtractor(HealthCheckProcessorSupport.HealthCheckItemExtractor<FluentAsset> extractor) {
        this.extractor = extractor;
    }

    static class HealthCheckAssetImpl
    extends HealthCheckProcessorSupport.HealthCheckAsset<FluentAsset> {
        public HealthCheckAssetImpl(FluentAsset asset) {
            super(asset);
        }

        @Override
        public String getPath() {
            return ((FluentAsset)this.asset).path();
        }

        @Override
        public long getLastAccess() {
            return ((FluentAsset)this.asset).lastDownloaded().map(OffsetDateTime::toInstant).map(Instant::toEpochMilli).orElse(0L);
        }

        @Override
        public String getSha1() {
            return ((FluentAsset)this.asset).blob().map(AssetBlob::checksums).map(c -> (String)c.get(HashAlgorithm.SHA1.name())).orElse(null);
        }
    }
}

