/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task;

import com.google.common.base.Preconditions;
import com.sonatype.insight.scan.anon.Anonymizer;
import com.sonatype.insight.scan.client.ClientScanRequest;
import com.sonatype.insight.scan.client.ClientScanner;
import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.DirectoryScanItem;
import com.sonatype.insight.scan.model.Repository;
import com.sonatype.insight.scan.model.Scan;
import com.sonatype.insight.scan.model.ScanConfiguration;
import com.sonatype.insight.scan.model.ScanItem;
import com.sonatype.insight.scan.model.io.ScanWriter;
import com.sonatype.nexus.plugins.healthcheck.service.NexusIDService;
import com.sonatype.nexus.plugins.healthcheck.task.HealthCheckItem;
import java.util.function.Function;
import java.util.function.Supplier;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.types.ProxyType;

public abstract class HealthCheckProcessorSupport
extends ComponentSupport {
    protected static final boolean ANONYMIZE_HEALTH_CHECK_ITEM_IDS = false;
    protected final ProxyType proxyType;
    protected final Format maven2Format;
    protected final Anonymizer scanAnonymizer;
    protected final ClientScanner clientScanner;
    protected final NexusIDService idService;
    protected Scan scan;
    protected long start;
    protected int items;
    protected int artifacts;
    protected int snapshots;
    protected ScanWriter scanWriter;

    protected HealthCheckProcessorSupport(Anonymizer anonymizer, ClientScanner clientScanner, NexusIDService idService, ProxyType proxyType, Format maven2Format) {
        this.scanAnonymizer = (Anonymizer)Preconditions.checkNotNull((Object)anonymizer);
        this.clientScanner = (ClientScanner)Preconditions.checkNotNull((Object)clientScanner);
        this.idService = (NexusIDService)Preconditions.checkNotNull((Object)idService);
        this.proxyType = (ProxyType)Preconditions.checkNotNull((Object)proxyType);
        this.maven2Format = (Format)Preconditions.checkNotNull((Object)maven2Format);
    }

    public boolean isStarted() {
        return this.start != 0L;
    }

    public void afterWalk(org.sonatype.nexus.repository.Repository repository) throws Exception {
        this.scan.getSummary().setEndTime();
        this.scan.getSummary().setFiles(this.items);
        this.scan.getSummary().setArchives(this.artifacts);
        this.scan.getSummary().setSnapshots(this.snapshots);
        this.scanWriter.writeSummary(this.scan.getSummary());
        this.scanWriter.writeConfiguration(this.scan.getConfiguration());
        this.scanWriter.closeScan();
        this.log.debug("Scan completed for repository {}: {} files, {} artifacts, {} ms", new Object[]{repository.getName(), this.items, this.artifacts, System.currentTimeMillis() - this.start});
        this.scan = null;
    }

    public void beforeWalk(org.sonatype.nexus.repository.Repository repo, Integer scanRate, ScanWriter scanWriter) throws Exception {
        this.start = System.currentTimeMillis();
        this.scanWriter = scanWriter;
        this.scan = new Scan();
        scanWriter.openScan(this.scan);
        String proxyUrl = null;
        if (this.proxyType.equals((Object)repo.getType())) {
            proxyUrl = ((ProxyFacet)repo.facet(ProxyFacet.class)).getRemoteUrl().toASCIIString();
        }
        Repository repository = new Repository(this.idService.getNexusID(), repo.getName(), repo.getName(), repo.getFormat().getValue(), proxyUrl);
        scanWriter.writeRepository(repository);
        ScanConfiguration scanConfig = this.scan.getConfiguration();
        scanConfig.setProperty((Object)"procArch", (Object)"true");
        scanConfig.setProperty((Object)"operatingSystem", (Object)"true");
        scanConfig.setProperty((Object)"jreInfo", (Object)"true");
        scanConfig.setProperty((Object)"ipAddresses", (Object)"false");
        scanConfig.setProperty((Object)"hashFiles", (Object)"true");
        scanConfig.setProperty((Object)"fileSizes", (Object)"false");
        scanConfig.setProperty((Object)"lastAccess", (Object)"true");
        scanConfig.setProperty((Object)"anonymizeArtifactIds", (Object)String.valueOf(false));
        scanConfig.setProperty((Object)"scanRate", (Object)String.valueOf(scanRate));
        this.scan.getSummary().setStartTime();
        this.clientScanner.scan(new ClientScanRequest(this.scan));
        this.log.debug("Scanning repository {} with rate of {} files per second", (Object)repo.getName(), (Object)scanRate);
    }

    public void processAsset(org.sonatype.nexus.repository.Repository repository, Supplier<HealthCheckItem> itemSupplier) throws Exception {
        if (this.log.isDebugEnabled() && this.items % 1000 == 0 && this.items > 0) {
            this.log.debug("Scan progress for repository {}: {} files, {} artifacts, {} ms", new Object[]{repository.getName(), this.items, this.artifacts, System.currentTimeMillis() - this.start});
        }
        ++this.items;
        HealthCheckItem healthCheckItem = itemSupplier.get();
        if (healthCheckItem == null) {
            return;
        }
        String id = healthCheckItem.getId();
        DirectoryScanItem item = new DirectoryScanItem();
        item.setSha1(healthCheckItem.getSha1());
        item.setLastAccess(healthCheckItem.getLastAccess());
        item.setId(id);
        item.setPath(healthCheckItem.getPath());
        this.scanWriter.writeScanItem((ScanItem)item);
        ++this.artifacts;
        if (healthCheckItem.isSnapshot()) {
            ++this.snapshots;
        }
    }

    public static abstract class HealthCheckAsset<T> {
        protected final T asset;

        public HealthCheckAsset(T asset) {
            this.asset = asset;
        }

        public abstract String getPath();

        public MavenPath getMavenPath(org.sonatype.nexus.repository.Repository repo) {
            return ((MavenFacet)repo.facet(MavenFacet.class)).getMavenPathParser().parsePath(this.getPath());
        }

        public abstract long getLastAccess();

        public abstract String getSha1();
    }

    public static class HealthCheckItemExtractor<T> {
        protected final Function<T, HealthCheckAsset<T>> assetCreator;

        public HealthCheckItemExtractor(Function<T, HealthCheckAsset<T>> assetCreator) {
            this.assetCreator = assetCreator;
        }

        public HealthCheckItem extract(T asset, org.sonatype.nexus.repository.Repository repo, boolean mavenRepository) {
            HealthCheckProcessorItem<T> healthCheckItem = new HealthCheckProcessorItem<T>(this.assetCreator.apply(asset), repo, mavenRepository);
            if (healthCheckItem.getPath() == null || healthCheckItem.getSha1() == null) {
                return null;
            }
            if (mavenRepository && healthCheckItem.getId() == null) {
                return null;
            }
            return healthCheckItem;
        }
    }

    private static class HealthCheckProcessorItem<T>
    implements HealthCheckItem {
        protected final HealthCheckAsset<T> asset;
        protected final org.sonatype.nexus.repository.Repository repo;
        protected final MavenPath mavenPath;
        protected final String path;
        protected final String id;
        protected final boolean snapshot;

        public HealthCheckProcessorItem(HealthCheckAsset<T> asset, org.sonatype.nexus.repository.Repository repo, boolean mavenRepository) {
            this.asset = asset;
            this.repo = repo;
            this.mavenPath = mavenRepository ? asset.getMavenPath(repo) : null;
            this.path = asset.getPath();
            this.id = this.createGavId(this.mavenPath);
            this.snapshot = this.checkSnapshot();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getSha1() {
            return this.asset.getSha1();
        }

        @Override
        public long getLastAccess() {
            return this.asset.getLastAccess();
        }

        @Override
        public boolean isSnapshot() {
            return this.snapshot;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        private String createGavId(MavenPath mavenPath) {
            if (mavenPath == null || mavenPath.getCoordinates() == null || mavenPath.isHash() || mavenPath.isSignature() || "pom".equals(mavenPath.getCoordinates().getExtension())) {
                return null;
            }
            MavenPath.Coordinates gav = mavenPath.getCoordinates();
            return ArtifactId.maven((String)gav.getGroupId(), (String)gav.getArtifactId(), (String)gav.getExtension(), (String)gav.getClassifier(), (String)gav.getVersion()).getId();
        }

        private boolean checkSnapshot() {
            if (this.mavenPath != null && this.mavenPath.getCoordinates() != null) {
                return this.mavenPath.getCoordinates().isSnapshot();
            }
            return false;
        }
    }
}

