/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.task;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.healthcheck.service.HdsService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.httpclient.config.HttpClientConfigurationChangedEvent;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named(value="HealthCheckEventInspector")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class HealthCheckActivation
extends StateGuardLifecycleSupport {
    private final RepositoryManager repositoryManager;
    private final RepositoryHealthCheckConfigurationService config;
    private final HealthCheckTaskManager taskManager;
    private final HdsService hdsService;

    @Inject
    public HealthCheckActivation(RepositoryManager repositoryManager, RepositoryHealthCheckConfigurationService config, HealthCheckTaskManager taskManager, HdsService hdsService) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.config = (RepositoryHealthCheckConfigurationService)Preconditions.checkNotNull((Object)config);
        this.taskManager = (HealthCheckTaskManager)Preconditions.checkNotNull((Object)taskManager);
        this.hdsService = (HdsService)Preconditions.checkNotNull((Object)hdsService);
    }

    protected void doStart() throws Exception {
        this.taskManager.start();
        this.taskManager.removeDuplicates();
        for (Repository repo : this.repositoryManager.browse()) {
            if (!this.taskManager.isSupported(repo)) continue;
            if (this.config.isEnabled(repo.getName())) {
                this.taskManager.scheduleTask(repo.getName());
                continue;
            }
            this.taskManager.stopTask(repo.getName());
        }
    }

    protected void doStop() throws Exception {
        this.taskManager.stop();
    }

    @Subscribe
    public void on(HttpClientConfigurationChangedEvent evt) {
        this.hdsService.resetHttpClient();
    }
}

