/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.plugins.healthcheck.service.LicenseService;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfiguration;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.service.internal.orient.OrientConfigProperty;
import com.sonatype.nexus.plugins.healthcheck.service.internal.orient.OrientRepositoryHealthCheckConfigurationEntityAdapter;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.manager.RepositoryDeletedEvent;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientRepositoryHealthCheckConfigurationService
extends StateGuardLifecycleSupport
implements RepositoryHealthCheckConfigurationService,
EventAware {
    private static final String SCAN_RATE_PROP = "scan.rate";
    private static final String HTTP_TIMEOUT_PROP = "http.timeout";
    private static final String USE_TRUST_STORE = "useTrustStore";
    private static final String ENABLED_PROP = "{repositoryName}.enabled";
    private static final String INSIGHT_URL_PROP = "insight.url";
    private final Provider<LicenseService> license;
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientRepositoryHealthCheckConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientRepositoryHealthCheckConfigurationService(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientRepositoryHealthCheckConfigurationEntityAdapter entityAdapter, Provider<LicenseService> license) {
        this.license = (Provider)Preconditions.checkNotNull(license);
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientRepositoryHealthCheckConfigurationEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void resetDefaults() {
        OrientTransactional.inTx(this.databaseInstance).run(db -> {
            for (OrientConfigProperty property : this.entityAdapter.browse(db)) {
                this.entityAdapter.deleteEntity(db, (Entity)property);
            }
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public String getInsightUrl() {
        Optional<String> value = this.getPropertyValue(INSIGHT_URL_PROP);
        if (value.isPresent()) {
            String val = value.get();
            return val.endsWith("/") ? val.substring(0, val.length() - 1) : val;
        }
        return ((LicenseService)this.license.get()).getDefaultInsightUrl();
    }

    @Override
    @Guarded(by={"STARTED"})
    public void setInsightUrl(String insightUrl) {
        this.writeProperty(new OrientConfigProperty().setName(INSIGHT_URL_PROP).setValue(insightUrl));
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean getUseTrustStore() {
        return this.getPropertyValue(USE_TRUST_STORE).map(Boolean::valueOf).orElse(false);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void setUseTrustStore(Boolean useTrustStore) {
        this.writeProperty(new OrientConfigProperty().setName(USE_TRUST_STORE).setValue(String.valueOf(useTrustStore)));
    }

    @Override
    public RepositoryHealthCheckConfiguration load() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(RepositoryHealthCheckConfiguration configuration) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean isEnabled(String repositoryName) {
        return this.getPropertyValue(ENABLED_PROP.replace("{repositoryName}", repositoryName)).map(Boolean::valueOf).orElse(false);
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean isConfigured(String repositoryName) {
        return this.getPropertyValue(ENABLED_PROP.replace("{repositoryName}", repositoryName)).isPresent();
    }

    @Override
    @Guarded(by={"STARTED"})
    public void setEnabled(String repositoryName, boolean enabled) {
        this.writeProperty(new OrientConfigProperty().setName(ENABLED_PROP.replace("{repositoryName}", repositoryName)).setValue(enabled ? "true" : "false"));
    }

    @Override
    @Guarded(by={"STARTED"})
    public int getScanRate() {
        return this.getIntegerPropertyValue(SCAN_RATE_PROP, 100);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void setScanRate(int scanRate) {
        this.writeProperty(new OrientConfigProperty().setName(SCAN_RATE_PROP).setValue(Integer.toString(scanRate)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public int getHttpTimeout() {
        return this.getIntegerPropertyValue(HTTP_TIMEOUT_PROP, -1);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void setHttpTimeout(int httpTimeout) {
        this.writeProperty(new OrientConfigProperty().setName(HTTP_TIMEOUT_PROP).setValue(Integer.toString(httpTimeout)));
    }

    private Optional<String> getPropertyValue(String propertyName) {
        ODocument document = (ODocument)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.selectProperty(db, propertyName));
        return document != null ? Optional.ofNullable((String)document.field("property_value", OType.STRING)) : Optional.empty();
    }

    @Subscribe
    public void on(RepositoryDeletedEvent event) {
        if (!EventHelper.isReplicating()) {
            String repositoryName = event.getRepository().getName();
            this.log.info("Removing healthcheck enabled property for {}", (Object)repositoryName);
            String enabledPropName = ENABLED_PROP.replace("{repositoryName}", repositoryName);
            OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.delete(db, enabledPropName));
        }
    }

    @VisibleForTesting
    int getIntegerPropertyValue(String propertyName, int defaultValue) {
        Optional<String> val = this.getPropertyValue(propertyName);
        try {
            return val.map(Integer::valueOf).orElse(defaultValue);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.warn("Invalid numeric value {} for {} property, defaulting to {}", new Object[]{val.get(), propertyName, defaultValue});
            return defaultValue;
        }
    }

    private void writeProperty(OrientConfigProperty property) {
        OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
            ODocument doc = this.entityAdapter.selectProperty(db, property.getName());
            if (doc != null) {
                this.entityAdapter.writeEntity(doc, (Entity)property);
            } else {
                this.entityAdapter.addEntity(db, (Entity)property);
            }
            return true;
        });
    }
}

