/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.BlobIdLocationResolver;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
public class WebServerServiceImpl
extends ComponentSupport
implements WebServerService {
    public static final String BUNDLE_ROOT = "health-check";
    private static final String REPORT_PROPS = "report.properties";
    private final MimeSupport mimeSupport;
    private final RepositoryManager repositoryManager;
    private final BlobStoreManager blobStoreManager;
    private final BlobIdLocationResolver blobIdLocationResolver;
    private String repositoryName;
    private String blobstoreName;

    @Inject
    public WebServerServiceImpl(MimeSupport mimeSupport, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, BlobIdLocationResolver blobIdLocationResolver) {
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.blobIdLocationResolver = (BlobIdLocationResolver)Preconditions.checkNotNull((Object)blobIdLocationResolver);
    }

    @Override
    public void initialize(String repositoryName) {
        this.repositoryName = repositoryName;
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository != null) {
            this.blobstoreName = (String)Preconditions.checkNotNull((Object)((String)repository.getConfiguration().attributes("storage").get("blobStoreName", String.class)));
        } else {
            this.log.debug("initialize: no repository found for name {}, blobstoreName will be null", (Object)repositoryName);
        }
    }

    @Override
    public void extractBundle(InputStream inputStream) throws IOException {
        HashSet<String> reportFiles = new HashSet<String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(inputStream));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String path = entry.getName().replace('\\', '/');
                reportFiles.add(path);
                this.extract(path, (InputStream)new CloseShieldInputStream((InputStream)zis));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.delete(reportFiles);
    }

    @Override
    public void extract(String path, InputStream is) throws IOException {
        BlobStore blobStore = this.blobStoreManager.get(this.blobstoreName);
        blobStore.create(is, this.blobHeaders(path));
    }

    @Override
    public WebServerService.ContentItem getContentItem(String path) throws IOException {
        this.log.debug("Getting path {}", (Object)path);
        Blob blob = this.getContentItemBlob(path);
        if (blob == null) {
            return null;
        }
        String mimeType = this.mimeSupport.guessMimeTypeFromPath((String)blob.getHeaders().get("BlobStore.blob-name"), new MimeRulesSource[0]);
        return new WebServerService.ContentItem(blob, mimeType);
    }

    @Override
    public boolean bundleExists() {
        try {
            if (this.getContentItem(REPORT_PROPS) != null) {
                return true;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    @Override
    public Properties getBundleProperties() {
        Properties props;
        block12: {
            props = new Properties();
            try {
                WebServerService.ContentItem ci = this.getContentItem(REPORT_PROPS);
                if (ci == null) break block12;
                if (ci.exists()) {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream is = ci.getBlob().getInputStream();){
                        props.load(is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                props.setProperty("timestamp", Long.toHexString(ci.getLastModified()));
            }
            catch (IOException e) {
                this.log.error("Unable to read report properties file from {}", (Object)REPORT_PROPS, (Object)e);
            }
        }
        return props;
    }

    String asBundlePath(BlobId blobId, String prefix) {
        return blobId.asUniqueString().substring(blobId.asUniqueString().lastIndexOf(prefix) + prefix.length() + 1);
    }

    private Blob getContentItemBlob(String path) {
        BlobId blobId;
        BlobStore blobStore = this.blobStoreManager.get(this.blobstoreName);
        if (!blobStore.exists(blobId = this.blobIdLocationResolver.fromHeaders(this.blobHeaders(path)))) {
            return null;
        }
        BlobAttributes blobAttributes = blobStore.getBlobAttributes(blobId);
        if (blobAttributes == null || blobAttributes.isDeleted()) {
            return null;
        }
        return blobStore.get(blobId);
    }

    private void delete(Set<String> excludes) {
        DateTime timestamp = DateTime.now();
        String prefix = String.format("%s/%s", BUNDLE_ROOT, this.repositoryName);
        BlobStore blobStore = this.blobStoreManager.get(this.blobstoreName);
        blobStore.getDirectPathBlobIdStream(prefix).filter(blobId -> !excludes.contains(this.asBundlePath((BlobId)blobId, prefix))).forEach(blobId -> {
            this.log.debug("removing old RHC bundle blob {}", blobId);
            blobStore.delete(blobId, "extracting new repository-health-check bundle at " + timestamp);
        });
    }

    private Map<String, String> blobHeaders(String path) {
        return ImmutableMap.of((Object)"BlobStore.created-by", (Object)"repository-health-check", (Object)"BlobStore.blob-name", (Object)String.format("%s/%s/%s", BUNDLE_ROOT, this.repositoryName, path), (Object)"BlobStore.direct-path", (Object)"true");
    }
}

