/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.sonatype.nexus.blobstore.api.Blob;

public interface WebServerService {
    public void initialize(String var1);

    public void extractBundle(InputStream var1) throws IOException;

    public void extract(String var1, InputStream var2) throws IOException;

    public ContentItem getContentItem(String var1) throws IOException;

    public boolean bundleExists();

    public Properties getBundleProperties();

    public static class ContentItem {
        private final Blob blob;
        private final String mediaType;

        public ContentItem(Blob blob, String mediaType) {
            this.blob = blob;
            this.mediaType = mediaType;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public String getFilename() {
            return (String)this.blob.getHeaders().get("BlobStore.blob-name");
        }

        public long getLastModified() {
            return this.blob.getMetrics().getCreationTime().toInstant().getMillis();
        }

        public boolean exists() {
            return this.blob != null;
        }

        public Blob getBlob() {
            return this.blob;
        }
    }
}

