/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.service;

import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfiguration;
import com.sonatype.nexus.plugins.healthcheck.service.RepositoryHealthCheckConfigurationService;
import com.sonatype.nexus.plugins.healthcheck.service.impl.RepositoryHealthCheckConfigurationData;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="repositoryHealthCheckConfigurationExport")
@Singleton
public class RepositoryHealthCheckConfigurationExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final RepositoryHealthCheckConfigurationService service;

    @Inject
    public RepositoryHealthCheckConfigurationExport(RepositoryHealthCheckConfigurationService service) {
        this.service = service;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export RepositoryHealthCheckConfiguration data to {}", (Object)file);
        RepositoryHealthCheckConfiguration configuration = this.service.load();
        this.exportObjectToJson(configuration, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring RepositoryHealthCheckConfiguration data from {}", (Object)file);
        Optional configuration = this.importObjectFromJson(file, RepositoryHealthCheckConfigurationData.class);
        configuration.ifPresent(this.service::save);
    }
}

