/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.MemorySecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityContributor;
import org.sonatype.nexus.security.config.SecurityContributorSupport;

@Named
@Singleton
public class HealthCheckSecurityContributor
extends SecurityContributorSupport
implements SecurityContributor {
    public static final String HEALTHCHECK_DOMAIN = "healthcheck";
    public static final String HEALTHCHECKSUMMARY_DOMAIN = "healthchecksummary";
    public static final String HEALTHCHECK_READ_PRIV_ID = "nx-healthcheck-read";
    public static final String HEALTHCHECK_UPDATE_PRIV_ID = "nx-healthcheck-update";
    public static final String HEALTHCHECK_SUMMARY_READ_PRIV_ID = "nx-healthcheck-summary-read";
    public static final String HEALTHCHECK_SUMMARY_READ_PRIV_DESCRIPTION = "Read permission for Healthcheck Summary";

    public SecurityConfiguration getContribution() {
        MemorySecurityConfiguration config = new MemorySecurityConfiguration();
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(HEALTHCHECK_READ_PRIV_ID, "Read permission for " + StringUtils.capitalize((String)HEALTHCHECK_DOMAIN), HEALTHCHECK_DOMAIN, "read"));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(HEALTHCHECK_UPDATE_PRIV_ID, "Update permission for " + StringUtils.capitalize((String)HEALTHCHECK_DOMAIN), HEALTHCHECK_DOMAIN, "update"));
        config.addPrivilege((CPrivilege)this.createApplicationPrivilege(HEALTHCHECK_SUMMARY_READ_PRIV_ID, HEALTHCHECK_SUMMARY_READ_PRIV_DESCRIPTION, HEALTHCHECKSUMMARY_DOMAIN, "read"));
        return config;
    }
}

