/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.firewall.internal.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.sonatype.clm.dto.model.policy.RepositoryPolicyEvaluationSummary;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.FirewallAuditCapabilityConfiguration;
import com.sonatype.nexus.clm.internal.FirewallTaskManager;
import com.sonatype.nexus.clm.internal.IQErrorManager;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.capability.ClmCapabilityDescriptor;
import com.sonatype.nexus.clm.internal.capability.FirewallAuditCapability;
import com.sonatype.nexus.clm.internal.capability.FirewallAuditCapabilityDescriptor;
import com.sonatype.nexus.plugins.firewall.internal.ui.FirewallRepositoryStatusXO;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.Permission;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.RepositoryPermissionChecker;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.privilege.ApplicationPermission;

@Named
@Singleton
@DirectAction(action={"firewall_RepositoryStatus"})
public class FirewallRepositoryStatusComponent
extends DirectComponentSupport {
    private RepositoryManager repositoryManager;
    private RestClientProvider restClientProvider;
    private CapabilityRegistry capabilityRegistry;
    private ClmConnector clmConnector;
    private IQErrorManager errorManager;
    private FirewallTaskManager firewallTaskManager;
    private SecurityHelper securityHelper;
    private RepositoryPermissionChecker repositoryPermissionChecker;

    @Inject
    public FirewallRepositoryStatusComponent(RepositoryManager repositoryManager, RestClientProvider restClientProvider, CapabilityRegistry capabilityRegistry, ClmConnector clmConnector, IQErrorManager errorManager, FirewallTaskManager firewallTaskManager, SecurityHelper securityHelper, RepositoryPermissionChecker repositoryPermissionChecker) {
        this.repositoryManager = repositoryManager;
        this.restClientProvider = restClientProvider;
        this.capabilityRegistry = capabilityRegistry;
        this.clmConnector = clmConnector;
        this.errorManager = errorManager;
        this.firewallTaskManager = firewallTaskManager;
        this.securityHelper = securityHelper;
        this.repositoryPermissionChecker = repositoryPermissionChecker;
    }

    @DirectMethod
    public List<FirewallRepositoryStatusXO> read() {
        boolean hasPermission = this.securityHelper.allPermitted(new Permission[]{new ApplicationPermission("iq-violation-summary", new String[]{"read"})});
        ExceptionStatus exceptionStatus = new ExceptionStatus();
        List repositories = StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).collect(Collectors.toList());
        List permittedRepositories = this.repositoryPermissionChecker.userHasRepositoryAdminPermission(repositories, new String[]{"read", "browse"});
        repositories.removeAll(permittedRepositories);
        permittedRepositories.addAll(this.repositoryPermissionChecker.userCanBrowseRepositories(repositories));
        return permittedRepositories.stream().map(repository -> this.getRepositoryStatusXO(repository.getName(), hasPermission, exceptionStatus)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @DirectMethod
    Boolean readCapabilitiesStatus(String repositoryName) {
        if (!this.isClmCapabilityPresentAndEnabled()) {
            return false;
        }
        if (!this.isFirewallAuditCapabilityEnabledAndQuarantineEnabled(repositoryName)) {
            return false;
        }
        return true;
    }

    private boolean isClmCapabilityPresentAndEnabled() {
        return this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(ClmCapabilityDescriptor.TYPE).includeNotExposed().enabled()).stream().findFirst().isPresent();
    }

    private boolean isFirewallAuditCapabilityEnabledAndQuarantineEnabled(String repositoryName) {
        Optional auditCapability = this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(FirewallAuditCapabilityDescriptor.TYPE).withProperty("repository", repositoryName).enabled()).stream().findFirst();
        if (!auditCapability.isPresent()) {
            return false;
        }
        return this.parseBoolean(((String)((CapabilityReference)auditCapability.get()).context().properties().get("quarantine")).toString(), false);
    }

    private Boolean parseBoolean(@Nullable String value, @Nullable Boolean defaultValue) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    @VisibleForTesting
    FirewallRepositoryStatusXO getRepositoryStatusXO(String repositoryName, boolean hasPermission, ExceptionStatus exceptionStatus) {
        Preconditions.checkNotNull((Object)repositoryName);
        CapabilityReference capabilityReference = this.getCapabilityReference(repositoryName);
        if (capabilityReference == null) {
            this.log.debug("Repository {} not configured for firewall.", (Object)repositoryName);
            return null;
        }
        FirewallRepositoryStatusXO repositoryStatusXO = new FirewallRepositoryStatusXO();
        repositoryStatusXO.setRepositoryName(repositoryName);
        if (!capabilityReference.context().isActive()) {
            repositoryStatusXO.setMessage(capabilityReference.context().stateDescription());
            return repositoryStatusXO;
        }
        if (!hasPermission) {
            if (((FirewallAuditCapabilityConfiguration)((Object)((FirewallAuditCapability)capabilityReference.capabilityAs(FirewallAuditCapability.class)).getConfig())).isQuarantineEnabled()) {
                repositoryStatusXO.setMessage("Quarantine enabled");
            } else {
                repositoryStatusXO.setMessage("Audit enabled");
            }
            return repositoryStatusXO;
        }
        if (this.clmConnector.getConfiguration() == null) {
            repositoryStatusXO.setErrorMessage("Connection to IQ Server not configured");
        } else if (this.firewallTaskManager.isAuditRunning(repositoryName)) {
            repositoryStatusXO.setErrorMessage("Audit in progress");
        } else {
            try {
                this.errorManager.reset(repositoryName);
                if (exceptionStatus.exception != null) {
                    Throwables.throwIfUnchecked((Throwable)exceptionStatus.exception);
                    throw new RuntimeException(exceptionStatus.exception);
                }
                RepositoryPolicyEvaluationSummary summary = this.restClientProvider.getRepositoryClient(repositoryName).getPolicyEvaluationSummary();
                repositoryStatusXO.setAffectedComponentCount(summary.getAffectedComponentCount());
                repositoryStatusXO.setCriticalComponentCount(summary.getCriticalComponentCount());
                repositoryStatusXO.setModerateComponentCount(summary.getModerateComponentCount());
                repositoryStatusXO.setSevereComponentCount(summary.getSevereComponentCount());
                repositoryStatusXO.setQuarantinedComponentCount(summary.getQuarantinedComponentCount());
                repositoryStatusXO.setReportUrl(summary.resolveReportUrl(this.clmConnector.getConfiguration().getUrl().toString()));
            }
            catch (IOException | RuntimeException exception) {
                this.errorManager.addErrorMessage(repositoryName, exception);
                exceptionStatus.exception = exception;
                repositoryStatusXO.setErrorMessage(this.errorManager.getErrorMessage(repositoryName));
            }
        }
        return repositoryStatusXO;
    }

    private CapabilityReference getCapabilityReference(String repositoryName) {
        Collection capabilities = this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(FirewallAuditCapabilityDescriptor.TYPE).withProperty("repository", repositoryName));
        if (capabilities.isEmpty()) {
            return null;
        }
        return (CapabilityReference)capabilities.iterator().next();
    }

    public static class ExceptionStatus {
        public Exception exception;
    }
}

