/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.service;

import com.sonatype.nexus.clm.vulnerability.api.ComponentConfigApi;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;

@Singleton
public class CustomQuarantineMessageService
extends ComponentSupport {
    private final ComponentConfigApi componentConfigApi;
    private final Provider<ClmService> clmServiceProvider;

    @Inject
    public CustomQuarantineMessageService(ComponentConfigApi componentConfigApi, Provider<ClmService> clmServiceProvider) {
        this.componentConfigApi = componentConfigApi;
        this.clmServiceProvider = clmServiceProvider;
    }

    public String getCustomQuarantineMessage() {
        ClmService clmService = (ClmService)this.clmServiceProvider.get();
        try {
            clmService.validateConfiguration();
            return this.componentConfigApi.getCustomQuarantineMessage(clmService);
        }
        catch (CompatibilityException e) {
            this.log.debug("Error getting custom quarantine message", (Throwable)e);
            return null;
        }
    }
}

