/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.sonatype.nexus.clm.vulnerability.api.ComponentRemediationApi;
import com.sonatype.nexus.clm.vulnerability.model.ComponentDetails;
import com.sonatype.nexus.clm.vulnerability.model.ComponentRemediation;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.ComponentEvaluationResult;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.EvaluationReport;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.vulnerability.exceptions.AppIdMismatchException;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ComponentRemediationService
extends StateGuardLifecycleSupport {
    private final ComponentRemediationApi remediationApi;
    private final int maxConcurrentRequests;
    private ExecutorService executor;

    @Inject
    public ComponentRemediationService(@Named(value="${nexus.clm.maxConcurrentRequests:-10}") @Named(value="${nexus.clm.maxConcurrentRequests:-10}") int maxConcurrentRequests, ComponentRemediationApi remediationApi) {
        Preconditions.checkArgument((maxConcurrentRequests > 0 ? 1 : 0) != 0, (Object)"nexus.clm.maxConcurrentRequests must be greater than 0");
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.remediationApi = remediationApi;
    }

    protected void doStart() {
        this.executor = NexusExecutorService.forCurrentSubject((ExecutorService)Executors.newFixedThreadPool(this.maxConcurrentRequests, (ThreadFactory)new NexusThreadFactory("clm-remediation-tasks", "clm-tasks")));
    }

    protected void doStop() throws InterruptedException {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            this.log.warn("Failed to terminate thread pool in allotted time");
        }
        this.executor = null;
    }

    public List<ComponentRemediation> getRemediationVersions(ClmService clmService, EvaluationReport evaluationReport, @Nullable String applicationId) throws AppIdMismatchException, VulnerabilityFetchingException, CompatibilityException {
        Set<String> packageUrls = this.getPackageUrls(evaluationReport);
        String internalApplicationId = clmService.getAppId(applicationId);
        ArrayList tasks = new ArrayList();
        packageUrls.forEach(packageUrl -> {
            boolean bl = tasks.add(() -> this.remediationApi.getComponentRemediation(clmService, (String)packageUrl, internalApplicationId));
        });
        Stopwatch sw = Stopwatch.createStarted();
        List componentRemediationFutures = tasks.stream().map(this.executor::submit).collect(Collectors.toList());
        ArrayList<ComponentRemediation> remediationVersions = new ArrayList<ComponentRemediation>();
        for (Future future : componentRemediationFutures) {
            this.fillComponentRemediationVersions(future, remediationVersions);
        }
        this.log.debug("Found [{}] components remediation for [{}] package URLs with total time [{}]", new Object[]{remediationVersions.size(), packageUrls.size(), sw.stop()});
        return remediationVersions;
    }

    private Set<String> getPackageUrls(EvaluationReport evaluationReport) {
        return evaluationReport.getResults().stream().filter(ComponentEvaluationResult::hasViolations).map(ComponentEvaluationResult::getComponent).map(ComponentDetails::getPackageUrl).collect(Collectors.toSet());
    }

    private void fillComponentRemediationVersions(Future<ComponentRemediation> future, List<ComponentRemediation> remediationVersions) throws VulnerabilityFetchingException, CompatibilityException {
        try {
            remediationVersions.add(future.get());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CompatibilityException) {
                throw new CompatibilityException(e.getCause().getMessage());
            }
            throw new VulnerabilityFetchingException(ViolationError.COMPONENT_REMEDIATION_ERROR.getMessage());
        }
        catch (InterruptedException e) {
            String errorMsg = "Getting component remediation versions from IQ has been interrupted";
            this.log.error(errorMsg);
            throw new RuntimeException(errorMsg, e);
        }
    }
}

