/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.sonatype.nexus.clm.vulnerability.api.ComponentEvaluationApi;
import com.sonatype.nexus.clm.vulnerability.model.ComponentRequest;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.EvaluationReport;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.vulnerability.AuditComponent;
import org.sonatype.nexus.repository.vulnerability.exceptions.AppIdMismatchException;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.IQServerException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ComponentEvaluationService
extends StateGuardLifecycleSupport {
    private final ComponentEvaluationApi detailsApi;
    private final int batchRequestSize;
    private final int maxConcurrentRequests;
    private ExecutorService executor;

    @Inject
    public ComponentEvaluationService(@Named(value="${nexus.clm.batchRequestSize:-100}") @Named(value="${nexus.clm.batchRequestSize:-100}") int batchRequestSize, @Named(value="${nexus.clm.maxConcurrentRequests:-10}") @Named(value="${nexus.clm.maxConcurrentRequests:-10}") int maxConcurrentRequests, ComponentEvaluationApi detailsApi) {
        Preconditions.checkArgument((batchRequestSize > 0 ? 1 : 0) != 0, (Object)"nexus.clm.batchRequestSize must be greater than 0");
        Preconditions.checkArgument((maxConcurrentRequests > 0 ? 1 : 0) != 0, (Object)"nexus.clm.maxConcurrentRequests must be greater than 0");
        this.batchRequestSize = batchRequestSize;
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.detailsApi = detailsApi;
    }

    protected void doStart() {
        this.executor = NexusExecutorService.forCurrentSubject((ExecutorService)Executors.newFixedThreadPool(this.maxConcurrentRequests, (ThreadFactory)new NexusThreadFactory("clm-evaluation-tasks", "clm-tasks")));
    }

    protected void doStop() throws InterruptedException {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            this.log.warn("Failed to terminate thread pool in allotted time");
        }
        this.executor = null;
    }

    public EvaluationReport getComponentEvaluationReport(ClmService clmService, Set<AuditComponent> components, String applicationId) throws AppIdMismatchException, VulnerabilityFetchingException, CompatibilityException, IQServerException {
        String internalApplicationId = clmService.getAppId(applicationId);
        List componentsRequests = components.stream().map(component -> new ComponentRequest(component.getPackageUrl())).collect(Collectors.toList());
        Stopwatch sw = Stopwatch.createStarted();
        List evaluationReportFutures = Streams.stream((Iterable)Iterables.partition(componentsRequests, (int)this.batchRequestSize)).map(componentsToEval -> () -> this.detailsApi.getComponentEvaluation(clmService, internalApplicationId, (List<ComponentRequest>)componentsToEval)).map(this.executor::submit).collect(Collectors.toList());
        ArrayList<EvaluationReport> evaluationReports = new ArrayList<EvaluationReport>();
        for (Future future : evaluationReportFutures) {
            this.fillEvaluationReports(future, evaluationReports);
        }
        this.log.debug("Evaluated [{}] components in [{}]", (Object)components.size(), (Object)sw.stop());
        EvaluationReport evaluationReport = new EvaluationReport();
        evaluationReports.forEach(report -> evaluationReport.addResults(report.getResults()));
        return evaluationReport;
    }

    private void fillEvaluationReports(Future<EvaluationReport> future, List<EvaluationReport> evaluationReports) throws VulnerabilityFetchingException, CompatibilityException, IQServerException {
        try {
            evaluationReports.add(future.get());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CompatibilityException) {
                throw new CompatibilityException(e.getCause().getMessage());
            }
            if (e.getCause() instanceof IQServerException) {
                throw new IQServerException(e.getCause().getMessage());
            }
            throw new VulnerabilityFetchingException(ViolationError.COMPONENT_EVALUATION_ERROR.getMessage());
        }
        catch (InterruptedException e) {
            String errorMsg = "Getting evaluation report from IQ has been interrupted";
            this.log.error(errorMsg);
            throw new RuntimeException(errorMsg, e);
        }
    }
}

