/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.service;

import com.sonatype.nexus.clm.vulnerability.api.ComponentDetailsApi;
import com.sonatype.nexus.clm.vulnerability.model.details.ComponentDetail;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.vulnerability.exceptions.InternalException;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ComponentDetailService
extends StateGuardLifecycleSupport {
    private final ComponentDetailsApi componentDetailsApi;

    @Inject
    public ComponentDetailService(ComponentDetailsApi componentDetailsApi) {
        this.componentDetailsApi = componentDetailsApi;
    }

    public Map<String, Date> getCatalogDates(ClmService clmService, List<PackageUrl> packageUrls) throws InternalException {
        List<ComponentDetail> componentDetails = this.componentDetailsApi.getComponentDetails(clmService, packageUrls).getComponentDetails();
        this.log.trace("Component Details => {}", componentDetails);
        return componentDetails.stream().collect(HashMap::new, (m, v) -> {
            Date date = m.put(v.getComponent().getPackageUrl(), v.getCatalogDate());
        }, HashMap::putAll);
    }
}

