/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.service;

import com.google.common.base.Preconditions;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.insight.rm.rest.RestClientFactory;
import com.sonatype.nexus.clm.ClmConfiguration;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.vulnerability.api.ApplicationsApi;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.vulnerability.exceptions.AppIdMismatchException;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;

public class ClmService {
    private static final Logger log = LoggerFactory.getLogger(ClmService.class);
    private static final long RETRY_INTERVAL_MS = 5000L;
    private final ClmConnector clmConnector;
    private final HttpClient httpClient;
    private final HttpClient notFoundRetryHttpClient;
    private final String url;

    @Inject
    public ClmService(final @Named(value="${nexus.npm.audit.timeout:-600}") @Named(value="${nexus.npm.audit.timeout:-600}") int timeout, ClmConnector clmConnector) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (Object)"nexus.npm.audit.timeout must be greater than 0");
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
        this.httpClient = clmConnector.createHttpClientBuilder().build();
        this.notFoundRetryHttpClient = clmConnector.createHttpClientBuilder().setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                int statusCode = response.getStatusLine().getStatusCode();
                return statusCode == 404 && (long)executionCount < (long)timeout / 5L;
            }

            public long getRetryInterval() {
                return 5000L;
            }
        }).build();
        this.url = ((ClmConfiguration)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector.getConfiguration())))).getUrl();
    }

    public String getUrl() {
        return this.url;
    }

    public HttpResponse executeGet(String path) throws IOException {
        return this.executeGet(path, Collections.emptyMap(), false);
    }

    public HttpResponse executeGet(String path, Map<String, List<Object>> queryParameters) throws IOException {
        return this.executeGet(path, queryParameters, false);
    }

    public HttpResponse executeGet(String path, Map<String, List<Object>> queryParameters, boolean retryOn404) throws IOException {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.url).path(path);
        for (Map.Entry<String, List<Object>> entry : queryParameters.entrySet()) {
            uriBuilder.queryParam(entry.getKey(), entry.getValue().toArray());
        }
        HttpGet request = new HttpGet(uriBuilder.build(new Object[0]));
        request.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        HttpClient httpClient = retryOn404 ? this.notFoundRetryHttpClient : this.httpClient;
        return httpClient.execute((HttpUriRequest)request);
    }

    public HttpResponse executePost(String path, String jsonBody) throws IOException {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.url).path(path);
        HttpPost request = new HttpPost(uriBuilder.build(new Object[0]));
        request.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        StringEntity stringEntity = new StringEntity(jsonBody, ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)stringEntity);
        return this.httpClient.execute((HttpUriRequest)request);
    }

    public InputStream executePostAndHandleResponse(String jsonRequest, String endpoint) throws IOException, CompatibilityException {
        HttpResponse response = this.executePost(endpoint, jsonRequest);
        HttpEntity entity = response.getEntity();
        int statusCode = response.getStatusLine().getStatusCode();
        if (entity.getContent() == null || statusCode != 200) {
            response.getEntity().getContent().close();
            if (statusCode == 404) {
                throw new CompatibilityException(ViolationError.IQ_SERVER_ENDPOINT_COMPATIBILITY_ERROR.getMessage());
            }
            throw new IOException("Bad response from " + endpoint);
        }
        return entity.getContent();
    }

    public InputStream executeGetAndHandleResponse(String endpoint) throws IOException, CompatibilityException {
        return this.executeGetAndHandleResponse(endpoint, false);
    }

    public InputStream executeGetAndHandleResponse(String endpoint, boolean retryOn404) throws IOException, CompatibilityException {
        HttpResponse response = this.executeGet(endpoint, Collections.emptyMap(), retryOn404);
        HttpEntity entity = response.getEntity();
        int statusCode = response.getStatusLine().getStatusCode();
        if (entity.getContent() == null || statusCode != 200) {
            response.getEntity().getContent().close();
            if (statusCode == 404) {
                throw new CompatibilityException(ViolationError.IQ_SERVER_ENDPOINT_COMPATIBILITY_ERROR.getMessage());
            }
            throw new IOException("Bad response from " + endpoint);
        }
        return entity.getContent();
    }

    public InputStream getConfigWithProperties(String ... properties) throws IOException, CompatibilityException {
        String endpoint = "/api/v2/config";
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.url).path(endpoint);
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            uriBuilder.queryParam("property", new Object[]{property});
            ++n2;
        }
        HttpGet request = new HttpGet(uriBuilder.build(new Object[0]));
        request.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        int statusCode = response.getStatusLine().getStatusCode();
        if (entity.getContent() == null || statusCode != 200) {
            if (statusCode == 404) {
                response.getEntity().getContent().close();
                throw new CompatibilityException(ViolationError.IQ_SERVER_V138_CONFIGURATION_ENDPOINT_NOT_FOUND_ERROR.getMessage());
            }
            if (statusCode == 400) {
                Throwable throwable = null;
                Object var9_13 = null;
                try (InputStream is = entity.getContent();){
                    String body = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    if (body.contains("Invalid property name")) {
                        throw new CompatibilityException(ViolationError.IQ_SERVER_PROPERTY_ENDPOINT_COMPATIBILITY_ERROR.getMessage());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            response.getEntity().getContent().close();
            throw new IOException("Bad response from " + endpoint);
        }
        return entity.getContent();
    }

    public String getAppId(String applicationId) throws AppIdMismatchException, VulnerabilityFetchingException, CompatibilityException {
        ApplicationsApi applicationsApi = new ApplicationsApi(this.clmConnector.getRestConfiguration());
        try {
            return applicationsApi.getAppId(applicationId);
        }
        catch (IOException e) {
            if (e instanceof HttpResponseException && ((HttpResponseException)e).getStatusCode() == 404) {
                throw new CompatibilityException(ViolationError.IQ_SERVER_ENDPOINT_COMPATIBILITY_ERROR.getMessage());
            }
            throw new VulnerabilityFetchingException(ViolationError.COMPONENT_APP_ERROR.getMessage());
        }
    }

    public void validateConfiguration() throws CompatibilityException {
        RestClient.Base baseRestClient = new RestClientFactory().forConfiguration(this.clmConnector.getRestConfiguration());
        try {
            baseRestClient.validateConfiguration();
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new CompatibilityException(ViolationError.IQ_SERVER_COMPATIBILITY_ERROR.getMessage());
        }
    }
}

