/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataRequestList;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.http.client.HttpResponseException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.vulnerability.AuditRepositoryComponent;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;

public class ComponentPolicyEvaluationApi
extends ComponentSupport {
    private static final int BATCH_REQUEST_SIZE = 100;
    private final RestClientProvider restClientProvider;

    @Inject
    public ComponentPolicyEvaluationApi(RestClientProvider restClientProvider) {
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
    }

    public RepositoryComponentEvaluationDataList evaluate(String repoName, Set<AuditRepositoryComponent> repositoryComponents) throws VulnerabilityFetchingException, CompatibilityException {
        Preconditions.checkNotNull((Object)repoName);
        RepositoryComponentEvaluationDataList result = new RepositoryComponentEvaluationDataList();
        RestClient.Repository repository = this.restClientProvider.getRepositoryClient(repoName);
        for (List components : Iterables.partition(repositoryComponents, (int)100)) {
            RepositoryComponentEvaluationDataRequestList request = this.buildEvaluationDataRequest(components);
            RepositoryComponentEvaluationDataList componentEvaluationData = this.evaluateComponents(repository, request);
            result.componentEvalResults.addAll(componentEvaluationData.componentEvalResults);
        }
        return result;
    }

    private RepositoryComponentEvaluationDataList evaluateComponents(RestClient.Repository repository, RepositoryComponentEvaluationDataRequestList request) throws VulnerabilityFetchingException, CompatibilityException {
        try {
            Stopwatch sw = Stopwatch.createStarted();
            RepositoryComponentEvaluationDataList evaluationData = repository.evaluateComponentsAdhoc(request);
            this.log.debug("Evaluated {} components in {}", (Object)evaluationData.componentEvalResults.size(), (Object)sw.stop());
            return evaluationData;
        }
        catch (IOException e) {
            if (e instanceof HttpResponseException && ((HttpResponseException)e).getStatusCode() == 404) {
                throw new CompatibilityException(ViolationError.IQ_SERVER_ADHOC_COMPATIBILITY_ERROR.getMessage());
            }
            throw new VulnerabilityFetchingException(ViolationError.COMPONENT_POLICY_EVALUATION_ERROR.getMessage());
        }
    }

    private RepositoryComponentEvaluationDataRequestList buildEvaluationDataRequest(List<AuditRepositoryComponent> repositoryComponents) {
        RepositoryComponentEvaluationDataRequestList request = new RepositoryComponentEvaluationDataRequestList();
        for (AuditRepositoryComponent repositoryComponent : repositoryComponents) {
            RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest component = this.buildComponent(repositoryComponent);
            request.components.add(component);
        }
        request.cause = "adhoc";
        return request;
    }

    private RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest buildComponent(AuditRepositoryComponent repositoryComponent) {
        RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest component = new RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest();
        component.format = repositoryComponent.getFormat();
        component.pathname = repositoryComponent.getPathname();
        component.hash = repositoryComponent.getHash();
        return component;
    }
}

