/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.api;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.sonatype.nexus.clm.vulnerability.model.ComponentRequest;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.EvaluationReport;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.IQServerException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;

public class ComponentEvaluationApi
extends ComponentSupport {
    private static final String COMPONENT_EVALUATION_REST_API = "api/v2/evaluation/applications";
    private final Gson gson = new Gson();

    public EvaluationReport getComponentEvaluation(ClmService service, String applicationId, List<ComponentRequest> componentRequests) throws VulnerabilityFetchingException, CompatibilityException, IQServerException {
        EvaluationReportLink evaluationReportLink;
        String jsonRequest = this.gson.toJson((Object)ImmutableMap.of((Object)"components", componentRequests));
        Stopwatch sw = Stopwatch.createStarted();
        try {
            Throwable throwable = null;
            Object var8_8 = null;
            try (InputStream is = service.executePostAndHandleResponse(jsonRequest, "api/v2/evaluation/applications/" + applicationId);){
                String json = IOUtils.toString((InputStream)is);
                evaluationReportLink = (EvaluationReportLink)this.gson.fromJson(json, EvaluationReportLink.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new VulnerabilityFetchingException(ViolationError.COMPONENT_EVALUATION_ERROR.getMessage());
        }
        EvaluationReport componentEvaluationReport = this.getComponentEvaluationReport(service, evaluationReportLink);
        this.log.debug("Evaluated {} components in {}", (Object)componentRequests.size(), (Object)sw.stop());
        return componentEvaluationReport;
    }

    private EvaluationReport getComponentEvaluationReport(ClmService service, EvaluationReportLink evaluationReportLink) throws VulnerabilityFetchingException, CompatibilityException, IQServerException {
        EvaluationReport evaluationReport;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = service.executeGetAndHandleResponse(evaluationReportLink.getResultUrl(), true);){
                String json = IOUtils.toString((InputStream)is);
                this.log.trace("IQ Response on evaluation report:\n{}", (Object)json);
                evaluationReport = (EvaluationReport)this.gson.fromJson(json, EvaluationReport.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.warn(ViolationError.COMPONENT_EVALUATION_ERROR.getMessage(), (Throwable)e);
            throw new VulnerabilityFetchingException(ViolationError.COMPONENT_EVALUATION_ERROR.getMessage());
        }
        if (evaluationReport.isError()) {
            throw new IQServerException(evaluationReport.getErrorMessage());
        }
        return evaluationReport;
    }

    private static final class EvaluationReportLink {
        private String resultId;
        private String submittedDate;
        private String applicationId;
        private String resultsUrl;

        private EvaluationReportLink() {
        }

        public String getResultId() {
            return this.resultId;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public LocalDateTime getSubmittedDate() {
            return LocalDateTime.parse(this.submittedDate, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }

        public String getResultUrl() {
            return this.resultsUrl;
        }

        public String toString() {
            return "EvaluationReportLink{resultId='" + this.resultId + '\'' + ", submittedDate='" + this.submittedDate + '\'' + ", applicationId='" + this.applicationId + '\'' + ", resultsUrl='" + this.resultsUrl + '\'' + '}';
        }
    }
}

