/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.api;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sonatype.nexus.clm.vulnerability.model.details.ComponentDetailsResponse;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.repository.vulnerability.exceptions.InternalException;

public class ComponentDetailsApi
extends ComponentSupport {
    private static final String COMPONENT_DETAILS_REST_API = "api/v2/components/details";
    private static final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").create();

    public ComponentDetailsResponse getComponentDetails(ClmService clmService, List<PackageUrl> packageUrls) throws InternalException {
        String jsonRequest = gson.toJson((Object)ImmutableMap.of((Object)"components", this.asComponents(packageUrls)));
        this.log.trace("IQ Request for component details: {}", (Object)jsonRequest);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = clmService.executePostAndHandleResponse(jsonRequest, COMPONENT_DETAILS_REST_API);){
                String json = IOUtils.toString((InputStream)is);
                this.log.trace("IQ Response for component details: {}", (Object)json);
                return (ComponentDetailsResponse)gson.fromJson(json, ComponentDetailsResponse.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.debug("Error getting component details", (Throwable)e);
            throw new InternalException("Error getting component details");
        }
    }

    private List<Map<String, String>> asComponents(List<PackageUrl> packageUrls) {
        return packageUrls.stream().map(p -> ImmutableMap.of((Object)"packageUrl", (Object)p.toString())).collect(Collectors.toList());
    }
}

