/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;

public class ComponentConfigApi
extends ComponentSupport {
    private static final String CUSTOM_QUARANTINED_MESSAGE_KEY = "quarantinedItemCustomMessage";
    private final Gson gson = new Gson();

    public String getCustomQuarantineMessage(ClmService service) throws CompatibilityException {
        String customMessage = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = service.getConfigWithProperties(CUSTOM_QUARANTINED_MESSAGE_KEY);){
                String jsonString = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                this.log.trace("IQ Response for custom quarantine message:\n{}", (Object)jsonString);
                JsonElement jsonElement = ((JsonObject)this.gson.fromJson(jsonString, JsonObject.class)).get(CUSTOM_QUARANTINED_MESSAGE_KEY);
                if (jsonElement != null && !jsonElement.isJsonNull()) {
                    customMessage = jsonElement.getAsString();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.warn("Error getting custom quarantine message", (Throwable)e);
        }
        return customMessage;
    }
}

