/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability.api;

import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.application.ApplicationSummary;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.insight.rm.rest.RestClientConfiguration;
import com.sonatype.insight.rm.rest.RestClientFactory;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.vulnerability.exceptions.AppIdMismatchException;

public class ApplicationsApi
extends ComponentSupport {
    private final RestClientConfiguration clientConfiguration;

    public ApplicationsApi(RestClientConfiguration clientConfiguration) {
        this.clientConfiguration = (RestClientConfiguration)Preconditions.checkNotNull((Object)clientConfiguration);
    }

    public String getAppId(String appId) throws AppIdMismatchException, IOException {
        RestClient.Base baseRestClient = new RestClientFactory().forConfiguration(this.clientConfiguration);
        List appSummaries = baseRestClient.getApplicationsForApplicationEvaluation().getApplicationSummaries();
        Optional<ApplicationSummary> appSummaryOpt = appSummaries.stream().filter(applicationSummary -> StringUtils.equalsIgnoreCase((CharSequence)applicationSummary.getPublicId(), (CharSequence)appId)).findFirst();
        if (!appSummaryOpt.isPresent()) {
            String msg = String.format(ViolationError.APP_ID_MISSING.getMessage(), appId);
            throw new AppIdMismatchException(msg);
        }
        ApplicationSummary appSummary = appSummaryOpt.get();
        this.log.debug("IQ Server Application Id: {} name: {}", (Object)appSummary.getId(), (Object)appSummary.getName());
        return appSummary.getId();
    }
}

