/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.eventbus.Subscribe;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.vulnerability.VulnerabilityMerger;
import com.sonatype.nexus.clm.vulnerability.api.ComponentPolicyEvaluationApi;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.vulnerability.RepositoryComponentValidation;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.ConfigurationException;
import org.sonatype.nexus.repository.vulnerability.exceptions.InternalException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;

@Named
@Singleton
public class RepositoryComponentVulnerabilityListener
extends ComponentSupport
implements EventAware {
    private final ClmConnector clmConnector;
    private final Provider<ClmService> clmServiceProvider;
    private final ComponentPolicyEvaluationApi policyEvaluationApi;
    private final VulnerabilityMerger vulnerabilityMerger;

    @Inject
    public RepositoryComponentVulnerabilityListener(ClmConnector clmConnector, Provider<ClmService> clmServiceProvider, VulnerabilityMerger vulnerabilityMerger, ComponentPolicyEvaluationApi policyEvaluationApi) {
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
        this.clmServiceProvider = (Provider)Preconditions.checkNotNull(clmServiceProvider);
        this.vulnerabilityMerger = (VulnerabilityMerger)Preconditions.checkNotNull((Object)vulnerabilityMerger);
        this.policyEvaluationApi = (ComponentPolicyEvaluationApi)((Object)Preconditions.checkNotNull((Object)((Object)policyEvaluationApi)));
    }

    @Subscribe
    public void on(RepositoryComponentValidation request) {
        if (!this.clmConnector.isActive() || !this.clmConnector.isConfigured()) {
            request.getVulnerabilityResult().completeExceptionally((Throwable)new ConfigurationException(ViolationError.IQ_SERVER_CONFIGURATION_ERROR.getMessage()));
            return;
        }
        try {
            this.processRequest(request);
        }
        catch (CompatibilityException | VulnerabilityFetchingException exception) {
            this.log.warn(exception.getMessage(), exception);
            request.getVulnerabilityResult().completeExceptionally(exception);
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage(), (Throwable)exception);
            request.getVulnerabilityResult().completeExceptionally(new InternalException(ViolationError.INTERNAL_ERROR.getMessage()));
        }
    }

    private void processRequest(RepositoryComponentValidation request) throws VulnerabilityFetchingException, CompatibilityException {
        ClmService clmService = (ClmService)this.clmServiceProvider.get();
        clmService.validateConfiguration();
        Stopwatch sw = Stopwatch.createStarted();
        RepositoryComponentEvaluationDataList componentEvalResults = this.policyEvaluationApi.evaluate(request.getRepositoryName(), request.getRepositoryComponents());
        this.log.debug("Evaluated {} components for {} repository in {}", new Object[]{request.getRepositoryComponents().size(), request.getRepositoryName(), sw.stop()});
        request.getVulnerabilityResult().complete(this.vulnerabilityMerger.getComponentsVulnerability(componentEvalResults, clmService.getUrl()));
    }
}

