/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.vulnerability.VulnerabilityMerger;
import com.sonatype.nexus.clm.vulnerability.model.ComponentRemediation;
import com.sonatype.nexus.clm.vulnerability.model.ComponentVulnerability;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import com.sonatype.nexus.clm.vulnerability.model.evaluation.EvaluationReport;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import com.sonatype.nexus.clm.vulnerability.service.ComponentEvaluationService;
import com.sonatype.nexus.clm.vulnerability.service.ComponentRemediationService;
import com.sonatype.nexus.clm.vulnerability.service.ComponentVulnerabilityService;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.vulnerability.ComponentValidation;
import org.sonatype.nexus.repository.vulnerability.exceptions.AppIdMismatchException;
import org.sonatype.nexus.repository.vulnerability.exceptions.CompatibilityException;
import org.sonatype.nexus.repository.vulnerability.exceptions.ConfigurationException;
import org.sonatype.nexus.repository.vulnerability.exceptions.IQServerException;
import org.sonatype.nexus.repository.vulnerability.exceptions.InternalException;
import org.sonatype.nexus.repository.vulnerability.exceptions.VulnerabilityFetchingException;

@Named
@Singleton
public class ComponentVulnerabilityListener
extends ComponentSupport
implements EventAware {
    private final ClmConnector clmConnector;
    private final Provider<ClmService> clmServiceProvider;
    private final ComponentRemediationService remediationService;
    private final ComponentVulnerabilityService vulnerabilityService;
    private final ComponentEvaluationService componentEvaluationService;
    private final VulnerabilityMerger vulnerabilityMerger;

    @Inject
    public ComponentVulnerabilityListener(ClmConnector clmConnector, Provider<ClmService> clmServiceProvider, ComponentRemediationService remediationService, ComponentVulnerabilityService vulnerabilityService, ComponentEvaluationService componentEvaluationService, VulnerabilityMerger vulnerabilityMerger) {
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
        this.clmServiceProvider = (Provider)Preconditions.checkNotNull(clmServiceProvider);
        this.remediationService = (ComponentRemediationService)((Object)Preconditions.checkNotNull((Object)((Object)remediationService)));
        this.vulnerabilityService = (ComponentVulnerabilityService)((Object)Preconditions.checkNotNull((Object)((Object)vulnerabilityService)));
        this.componentEvaluationService = (ComponentEvaluationService)((Object)Preconditions.checkNotNull((Object)((Object)componentEvaluationService)));
        this.vulnerabilityMerger = (VulnerabilityMerger)Preconditions.checkNotNull((Object)vulnerabilityMerger);
    }

    @Subscribe
    public void on(ComponentValidation request) {
        if (!this.clmConnector.isActive() || !this.clmConnector.isConfigured()) {
            request.getVulnerabilityResult().completeExceptionally((Throwable)new ConfigurationException(ViolationError.IQ_SERVER_CONFIGURATION_ERROR.getMessage()));
            return;
        }
        try {
            this.processRequest(request);
        }
        catch (AppIdMismatchException | CompatibilityException | IQServerException | VulnerabilityFetchingException exception) {
            request.getVulnerabilityResult().completeExceptionally(exception);
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage(), (Throwable)exception);
            request.getVulnerabilityResult().completeExceptionally(new InternalException(ViolationError.INTERNAL_ERROR.getMessage()));
        }
    }

    private void processRequest(ComponentValidation request) throws AppIdMismatchException, CompatibilityException, VulnerabilityFetchingException, IQServerException {
        ClmService clmService = (ClmService)this.clmServiceProvider.get();
        clmService.validateConfiguration();
        Set components = request.getAuditComponents();
        this.log.debug("Analyzing {} components on vulnerabilities...", (Object)components.size());
        Stopwatch sw = Stopwatch.createStarted();
        EvaluationReport evaluationReport = this.componentEvaluationService.getComponentEvaluationReport(clmService, components, request.getApplicationId());
        List<ComponentVulnerability> vulnerabilities = this.vulnerabilityService.getVulnerabilities(clmService, evaluationReport);
        List<ComponentRemediation> remediationVersions = this.remediationService.getRemediationVersions(clmService, evaluationReport, request.getApplicationId());
        this.log.debug("Evaluation components took {}", (Object)sw.stop());
        request.getVulnerabilityResult().complete(this.vulnerabilityMerger.getComponentsVulnerability(components, evaluationReport, vulnerabilities, remediationVersions, clmService.getUrl()));
    }
}

