/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.vulnerability;

import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.vulnerability.model.ViolationError;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.vulnerability.ComponentValidationAvailable;
import org.sonatype.nexus.repository.vulnerability.exceptions.ConfigurationException;

@Named
@Singleton
public class ClmConnectorListener
extends ComponentSupport
implements EventAware {
    private final ClmConnector clmConnector;

    @Inject
    public ClmConnectorListener(ClmConnector clmConnector) {
        this.clmConnector = clmConnector;
    }

    @Subscribe
    public void on(ComponentValidationAvailable request) {
        if (!this.clmConnector.isActive() || !this.clmConnector.isConfigured()) {
            request.getResult().completeExceptionally((Throwable)new ConfigurationException(ViolationError.IQ_SERVER_CONFIGURATION_ERROR.getMessage()));
            return;
        }
        request.getResult().complete(true);
    }
}

