/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.proprietary.orient;

import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.component.ProprietaryComponentNames;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.proprietary.FirewallProprietaryNameTask;
import com.sonatype.nexus.clm.internal.proprietary.FirewallProprietaryNameTaskHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
@TaskLogging(value=TaskLogType.TASK_LOG_ONLY)
public class OrientFirewallProprietaryNameTask
extends RepositoryTaskSupport
implements Cancelable,
FirewallProprietaryNameTask {
    private final int batchSize;
    private final RestClientProvider restClientProvider;
    private boolean failed = false;

    @Inject
    public OrientFirewallProprietaryNameTask(RestClientProvider restClientProvider, @Named(value="${nexus.firewall.name.batch:-100}") @Named(value="${nexus.firewall.name.batch:-100}") int batchSize) {
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.batchSize = batchSize;
    }

    public String getMessage() {
        return "Synchronize proprietary component names with IQ";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(Repository repository) {
        TreeSet<String> names;
        TreeSet<String> namespaces;
        RestClient.Repository client;
        block21: {
            if (!this.appliesTo(repository)) {
                this.log.debug("Skipping repository {}", (Object)repository.getName());
                return;
            }
            this.log.info("Starting repository {}", (Object)repository.getName());
            TreeSet<String> submittedNames = new TreeSet<String>();
            TreeSet<String> submittedNamespaces = new TreeSet<String>();
            client = this.restClientProvider.getRepositoryClient(repository.getName());
            namespaces = new TreeSet<String>();
            names = new TreeSet<String>();
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                StorageTx tx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();
                try {
                    try (ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);){
                        tx.begin();
                        long componentCount = tx.countComponents(null, null, Collections.singleton(repository), null);
                        long processed = 0L;
                        Bucket bucket = tx.findBucket(repository);
                        for (Component component : tx.browseComponents(bucket)) {
                            CancelableHelper.checkCancellation();
                            if (!FirewallProprietaryNameTaskHelper.shouldUseGroupOrNamespace(component.format(), component.group())) {
                                if (!submittedNames.contains(component.name())) {
                                    names.add(component.name());
                                    submittedNames.add(component.name());
                                }
                            } else {
                                String namespace;
                                String string = namespace = "npm".equals(repository.getFormat().getValue()) ? String.valueOf('@') + component.group() : component.group();
                                if (!submittedNamespaces.contains(namespace)) {
                                    submittedNamespaces.add(namespace);
                                    namespaces.add(namespace);
                                } else if (namespace != null && namespace.isEmpty() && !component.name().isEmpty() && !submittedNames.contains(component.name())) {
                                    names.add(component.name());
                                    submittedNames.add(component.name());
                                }
                            }
                            progressLogger.info("Processed {} of {} components", new Object[]{++processed, componentCount});
                            this.maybeSubmit(client, repository, namespaces, names);
                        }
                    }
                    if (tx == null) break block21;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (tx == null) throw throwable;
                    tx.close();
                    throw throwable;
                }
                tx.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.submit(client, repository, namespaces, names);
        if (!this.failed) return;
        throw new RuntimeException("Marking as failed due to an earlier error.");
    }

    private void maybeSubmit(RestClient.Repository client, Repository repository, Collection<String> namespaces, Collection<String> names) {
        if (namespaces.size() + names.size() < this.batchSize) {
            return;
        }
        this.submit(client, repository, namespaces, names);
    }

    private void submit(RestClient.Repository client, Repository repository, Collection<String> namespaces, Collection<String> names) {
        if (names.isEmpty() && namespaces.isEmpty()) {
            return;
        }
        this.log.info("Submitting progress to IQ");
        try {
            ProprietaryComponentNames dto = new ProprietaryComponentNames(repository.getFormat().getValue(), new String[0]);
            dto.addNames(names);
            dto.addNamespaces(namespaces);
            this.log.debug("Submitting proprietary component names: ({})", (Object)dto);
            client.addProprietaryComponentNames(dto);
        }
        catch (IOException e) {
            this.failed = true;
            this.log.error("Failed to submit entries", (Throwable)e);
        }
        namespaces.clear();
        names.clear();
    }

    protected boolean appliesTo(Repository repository) {
        return FirewallProprietaryNameTaskHelper.taskAppliesToRepository(repository);
    }
}

