/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.proprietary.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.component.ProprietaryComponentNames;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.proprietary.FirewallProprietaryNameTask;
import com.sonatype.nexus.clm.internal.proprietary.FirewallProprietaryNameTaskHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLogType;
import org.sonatype.nexus.logging.task.TaskLogging;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
@TaskLogging(value=TaskLogType.TASK_LOG_ONLY)
public class DatastoreFirewallProprietaryNameTask
extends RepositoryTaskSupport
implements FirewallProprietaryNameTask {
    private final int batchSize;
    private final int browseBatchSize;
    private final RestClientProvider restClientProvider;
    private boolean failed = false;

    @Inject
    public DatastoreFirewallProprietaryNameTask(RestClientProvider restClientProvider, @Named(value="${nexus.firewall.name.batch:-100}") @Named(value="${nexus.firewall.name.batch:-100}") int batchSize, @Named(value="${nexus.firewall.name.browseBatchSize:-1000}") @Named(value="${nexus.firewall.name.browseBatchSize:-1000}") int browseBatchSize) {
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.batchSize = batchSize;
        this.browseBatchSize = browseBatchSize;
    }

    protected boolean appliesTo(Repository repository) {
        return FirewallProprietaryNameTaskHelper.taskAppliesToRepository(repository);
    }

    public String getMessage() {
        return "Synchronize proprietary component names with IQ";
    }

    protected void execute(Repository repository) {
        if (!this.appliesTo(repository)) {
            this.log.debug("Skipping repository {}", (Object)repository.getName());
            return;
        }
        this.log.info("Starting repository {}", (Object)repository.getName());
        TreeSet<String> submittedNames = new TreeSet<String>();
        TreeSet<String> submittedNamespaces = new TreeSet<String>();
        RestClient.Repository client = this.restClientProvider.getRepositoryClient(repository.getName());
        TreeSet<String> namespaces = new TreeSet<String>();
        TreeSet<String> names = new TreeSet<String>();
        Throwable throwable = null;
        Object var8_9 = null;
        try (ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);){
            long componentCount = ((ContentFacet)repository.facet(ContentFacet.class)).components().count();
            long processed = 0L;
            Continuation components = ((ContentFacet)repository.facet(ContentFacet.class)).components().browse(this.browseBatchSize, null);
            while (!components.isEmpty()) {
                for (Component component : components) {
                    CancelableHelper.checkCancellation();
                    if (!FirewallProprietaryNameTaskHelper.shouldUseGroupOrNamespace(repository.getFormat().getValue(), component.namespace())) {
                        if (!submittedNames.contains(component.name())) {
                            names.add(component.name());
                            submittedNames.add(component.name());
                        }
                    } else {
                        String namespace;
                        String string = namespace = "npm".equals(repository.getFormat().getValue()) ? String.valueOf('@') + component.namespace() : component.namespace();
                        if (!namespace.isEmpty() && !submittedNamespaces.contains(namespace)) {
                            submittedNamespaces.add(namespace);
                            namespaces.add(namespace);
                        } else if (namespace.isEmpty() && !component.name().isEmpty() && !submittedNames.contains(component.name())) {
                            names.add(component.name());
                            submittedNames.add(component.name());
                        }
                    }
                    progressLogger.info("Processed {} of {} components", new Object[]{++processed, componentCount});
                    this.maybeSubmit(client, repository, namespaces, names);
                }
                components = ((ContentFacet)repository.facet(ContentFacet.class)).components().browse(this.batchSize, components.nextContinuationToken());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.submit(client, repository, namespaces, names);
        if (this.failed) {
            throw new RuntimeException("Marking as failed due to an earlier error.");
        }
    }

    private void maybeSubmit(RestClient.Repository client, Repository repository, Collection<String> namespaces, Collection<String> names) {
        if (namespaces.size() + names.size() < this.batchSize) {
            return;
        }
        this.submit(client, repository, namespaces, names);
    }

    private void submit(RestClient.Repository client, Repository repository, Collection<String> namespaces, Collection<String> names) {
        if (names.isEmpty() && namespaces.isEmpty()) {
            return;
        }
        this.log.info("Submitting progress to IQ");
        try {
            ProprietaryComponentNames dto = new ProprietaryComponentNames(repository.getFormat().getValue(), new String[0]);
            dto.addNames(names);
            dto.addNamespaces(namespaces);
            this.log.debug("Submitting proprietary component names: ({})", (Object)dto);
            client.addProprietaryComponentNames(dto);
        }
        catch (IOException e) {
            this.failed = true;
            this.log.error("Failed to submit entries", (Throwable)e);
        }
        namespaces.clear();
        names.clear();
    }
}

