/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.proprietary;

import com.sonatype.nexus.clm.internal.proprietary.FirewallProprietaryNameTaskManager;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonatype.nexus.repository.Repository;

public class FirewallProprietaryNameTaskHelper {
    private static final Set<String> namedFormats = Stream.of("apt", "conda", "r", "conan", "pypi", "rubygems").collect(Collectors.toSet());

    public static boolean shouldUseGroupOrNamespace(String format, String groupOrNamespace) {
        if (namedFormats.contains(format)) {
            return false;
        }
        return groupOrNamespace != null;
    }

    public static boolean taskAppliesToRepository(Repository repository) {
        String format = repository.getFormat().getValue();
        return !"raw".equals(format) && !"gitlfs".equals(format) && FirewallProprietaryNameTaskManager.isProprietaryFlagged(repository);
    }
}

