/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.IQErrorManager;
import com.sonatype.nexus.clm.internal.RequestUtils;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;

@Named
@Singleton
public class RemovedAssetSender
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final RestClientProvider restClientProvider;
    private final IQErrorManager iqErrorManager;
    static final String PROPERTY_PREFIX = "nexus.removedAssetSender.";
    static final int DELAY_SEND_REQUEST_SECONDS = SystemPropertiesHelper.getInteger((String)"nexus.removedAssetSender.delaySendRequestSeconds", (int)1);
    static final int DELAY_MULTIPLIER = SystemPropertiesHelper.getInteger((String)"nexus.removedAssetSender.delayMultiplier", (int)2);
    static final int NUMBER_OF_ATTEMPTS = SystemPropertiesHelper.getInteger((String)"nexus.removedAssetSender.numberOfAttemptsToSendRequest", (int)5);

    @Inject
    public RemovedAssetSender(RepositoryAttributeStorage repositoryAttributeStorage, RestClientProvider restClientProvider, IQErrorManager iqErrorManager) {
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.iqErrorManager = (IQErrorManager)((Object)Preconditions.checkNotNull((Object)((Object)iqErrorManager)));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDeleteAsset(AssetDeletedEvent assetDeletedEvent) {
        String assetName;
        String repositoryName;
        if (assetDeletedEvent.isLocal() && this.repositoryAttributeStorage.isAuditEnabled(repositoryName = assetDeletedEvent.getRepositoryName(), true) && !this.executeRequest(repositoryName, assetName = assetDeletedEvent.getAsset().name())) {
            this.log.debug("numberOfAttemptsToSendRequest = {}", (Object)NUMBER_OF_ATTEMPTS);
            this.log.debug("delaySendRequestSeconds = {}", (Object)DELAY_SEND_REQUEST_SECONDS);
            this.log.debug("delayMultiplier = {}", (Object)DELAY_MULTIPLIER);
            int i = 0;
            while (i < NUMBER_OF_ATTEMPTS) {
                int delay = DELAY_SEND_REQUEST_SECONDS * DELAY_MULTIPLIER ^ i;
                this.log.debug("delay  = {}", (Object)delay);
                RequestUtils.pause(delay);
                if (this.executeRequest(repositoryName, assetName)) break;
                ++i;
            }
        }
    }

    @VisibleForTesting
    boolean executeRequest(String repositoryName, String assetName) {
        try {
            this.iqErrorManager.reset(repositoryName);
            this.restClientProvider.getRepositoryClient(repositoryName).removeComponent(assetName);
        }
        catch (IOException | RuntimeException e) {
            this.log.warn(String.format("Problem notifying IQ server of removed asset %s:%s: %s", repositoryName, assetName, e.getMessage()), (Throwable)(this.log.isDebugEnabled() ? e : null));
            this.iqErrorManager.addErrorMessage(repositoryName, e);
            return false;
        }
        return true;
    }
}

