/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.AttributeUtils;
import com.sonatype.nexus.clm.internal.RepositoryAuditFileWalkerProcessor;
import com.sonatype.nexus.clm.internal.orient.AssetAttributeStorage;
import com.sonatype.nexus.clm.internal.orient.IsAssetAuditable;
import com.sonatype.nexus.clm.internal.orient.RepositoryAuditExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientRepositoryAuditFileWalkerProcessor
implements RepositoryAuditFileWalkerProcessor {
    private final int batchSize = SystemPropertiesHelper.getInteger((String)"nexus.firewall.audit.batchSize", (int)100);
    private long start;
    private static final Logger log = LoggerFactory.getLogger(OrientRepositoryAuditFileWalkerProcessor.class);
    private Long repositoryAuditTimestamp;
    private final RepositoryAuditExecutor executor;
    private List<Asset> batchedAssets;
    private int fileCount;
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final AssetAttributeStorage assetAttributeStorage;
    private final IsAssetAuditable isAssetAuditable;
    private int componentCount;

    @Inject
    public OrientRepositoryAuditFileWalkerProcessor(RepositoryAuditExecutor executor, RepositoryAttributeStorage repositoryAttributeStorage, AssetAttributeStorage assetAttributeStorage, IsAssetAuditable isAssetAuditable) {
        this.executor = (RepositoryAuditExecutor)((Object)Preconditions.checkNotNull((Object)((Object)executor)));
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
        this.isAssetAuditable = (IsAssetAuditable)Preconditions.checkNotNull((Object)isAssetAuditable);
    }

    private void resetBatch() {
        this.batchedAssets = new ArrayList<Asset>(this.batchSize);
    }

    void beforeWalk(Repository repository, String evalTimestamp) {
        String repoName = repository.getName();
        this.start = System.currentTimeMillis();
        this.repositoryAuditTimestamp = AttributeUtils.tryParse(evalTimestamp, Long::valueOf);
        this.resetBatch();
        log.debug("Walk started for repository: {} timestamp: {}", (Object)repoName, (Object)this.repositoryAuditTimestamp);
    }

    void afterWalk(Repository repository) throws Exception {
        if (!this.batchedAssets.isEmpty()) {
            this.executeEvaluation(repository);
        }
        this.executor.awaitCompletion();
        this.repositoryAttributeStorage.clearAuditTimestamp(repository.getName());
        if (log.isDebugEnabled()) {
            long millis = System.currentTimeMillis() - this.start;
            float componentsPerMinute = (float)this.componentCount * 60000.0f / (float)millis;
            log.debug("Audit completed for repository {} in {} ms, {} files, {} components audited ({} per minute)", new Object[]{repository.getName(), millis, this.fileCount, this.componentCount, Float.valueOf(componentsPerMinute)});
        }
    }

    @Override
    public void walk(Repository repo, String evalTimestamp) throws Exception {
        this.beforeWalk(repo, evalTimestamp);
        if (this.repositoryAuditTimestamp != null) {
            this.processAssets(repo);
        } else {
            log.debug("Skipped audit for repository: {} invalid timestamp: {}", (Object)repo.getName(), (Object)evalTimestamp);
        }
        this.afterWalk(repo);
    }

    private void processAssets(Repository repo) throws Exception {
        String lastAssetName = null;
        while (true) {
            CancelableHelper.checkCancellation();
            Asset lastAsset = null;
            for (Asset asset : this.findAssets(repo, lastAssetName)) {
                this.processAsset(repo, asset);
                lastAsset = asset;
            }
            if (lastAsset == null) break;
            lastAssetName = lastAsset.name();
        }
    }

    private Iterable<Asset> findAssets(Repository repository, String lastAssetName) throws Exception {
        return (Iterable)Transactional.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).throwing(Exception.class).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            return tx.findAssets(lastAssetName != null ? "name > :lastAssetName" : null, Collections.singletonMap("lastAssetName", lastAssetName), Collections.singleton(repository), "ORDER BY name ASC LIMIT " + this.batchSize);
        });
    }

    protected void processAsset(Repository repository, Asset asset) throws Exception {
        ++this.fileCount;
        if (this.shouldAudit(asset)) {
            ++this.componentCount;
            log.trace("Auditing file {}", (Object)asset.name());
            this.batchedAssets.add(asset);
            if (this.batchedAssets.size() >= this.batchSize) {
                this.executeEvaluation(repository);
            }
        } else {
            log.trace("Not auditing file {}", (Object)asset.name());
        }
    }

    private void executeEvaluation(Repository repository) throws Exception {
        CancelableHelper.checkCancellation();
        this.executor.executeEvaluation(this.batchedAssets, repository);
        this.resetBatch();
    }

    private boolean shouldAudit(Asset asset) {
        DateTime blobUpdatedTime;
        Long assetAuditTimestamp;
        return !(!this.isAssetAuditable.test(asset) || (assetAuditTimestamp = this.assetAttributeStorage.getAuditTimestamp(asset)) != null && assetAuditTimestamp >= this.repositoryAuditTimestamp || (blobUpdatedTime = asset.blobUpdated()) != null && !blobUpdatedTime.isBefore(this.repositoryAuditTimestamp.longValue()));
    }
}

