/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorageSupport;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.orient.ReplicationModeOverrides;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.manager.RepositoryMetadataUpdatedEvent;

@Named
@Priority(value=0x7FFFFFFF)
@Singleton
public class OrientRepositoryAttributeStorage
extends RepositoryAttributeStorageSupport
implements EventAware {
    @Inject
    public OrientRepositoryAttributeStorage(RepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    protected void removeFirewallAttributes(Repository repository) {
        ((AttributesFacet)repository.facet(AttributesFacet.class)).modifyAttributes(attributes -> {
            Object object = attributes.remove("firewall");
        });
    }

    @Override
    protected NestedAttributesMap getFirewallAttributes(Repository repository) {
        return ((AttributesFacet)repository.facet(AttributesFacet.class)).getAttributes().child("firewall");
    }

    @Override
    protected void saveFirewallAttributes(Repository repository, Map<String, ?> attributeChanges) {
        ((AttributesFacet)repository.facet(AttributesFacet.class)).modifyAttributes(attributes -> {
            NestedAttributesMap firewallAttributes = attributes.child("firewall");
            for (Map.Entry attribute : attributeChanges.entrySet()) {
                if (attribute.getValue() != null) {
                    firewallAttributes.set((String)attribute.getKey(), attribute.getValue());
                    continue;
                }
                firewallAttributes.remove((String)attribute.getKey());
            }
        });
    }

    @Override
    public void setLastServerError(String repositoryName, @Nullable String serverError) {
        if (this.updateErrorState(repositoryName, serverError)) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("lastServerError", serverError);
            ReplicationModeOverrides.dontWaitForReplicationResults();
            try {
                this.saveAttributes(repositoryName, attributes);
            }
            finally {
                ReplicationModeOverrides.clearReplicationModeOverrides();
            }
        }
    }

    @Subscribe
    public void onRepositoryMetadataUpdatedEvent(RepositoryMetadataUpdatedEvent event) {
        this.cleanAttributesCache(event.getRepository().getName());
    }
}

