/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.storage.Asset;

@Named
@Singleton
public class IsAssetAuditable
implements Predicate<Asset>,
EventAware {
    private volatile Map<String, List<Pattern>> regexpsByFormat = ImmutableMap.of();

    @Subscribe
    @AllowConcurrentEvents
    public void onFirewallIgnorePatternsChanged(FirewallIgnorePatternsEvent event) {
        this.regexpsByFormat = this.compileRegexps(event.getRegexpsByFormat());
    }

    @Override
    public boolean test(Asset asset) {
        return asset != null && !StringUtils.isBlank((String)asset.name()) && asset.getChecksum(HashAlgorithm.SHA1) != null && this.pathNotIgnored(asset.format(), asset.name());
    }

    private boolean pathNotIgnored(String format, String path) {
        List<Pattern> regexps = this.regexpsByFormat.get(format);
        return regexps == null || regexps.stream().noneMatch(regexp -> regexp.matcher(path).matches());
    }

    private Map<String, List<Pattern>> compileRegexps(Map<String, List<String>> regexpsByFormat) {
        HashMap<String, List<Pattern>> compiledMap = new HashMap<String, List<Pattern>>();
        for (Map.Entry<String, List<String>> entry : regexpsByFormat.entrySet()) {
            String format = entry.getKey();
            List<String> regexps = entry.getValue();
            if (regexps == null || regexps.isEmpty()) continue;
            compiledMap.put(format, regexps.stream().map(Pattern::compile).collect(Collectors.toList()));
        }
        return compiledMap;
    }
}

