/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.migration.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsUpdater;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.migration.AbstractFirewallMigrationHelperImpl;
import com.sonatype.nexus.clm.internal.orient.AssetAttributeStorage;
import com.sonatype.nexus.clm.internal.orient.IsAssetAuditable;
import com.sonatype.nexus.clm.migration.orient.OrientFirewallMigrationHelper;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.node.DeploymentAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.storage.Asset;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientFirewallMigrationHelperImpl
extends AbstractFirewallMigrationHelperImpl
implements OrientFirewallMigrationHelper {
    private final AssetAttributeStorage assetAttributeStorage;
    private final IsAssetAuditable isAssetAuditable;

    @Inject
    public OrientFirewallMigrationHelperImpl(DeploymentAccess deploymentAccess, CapabilityRegistry capabilityRegistry, RestClientProvider restClientProvider, ClmConnector clmConnector, FirewallIgnorePatternsUpdater ignorePatternsUpdater, RepositoryAttributeStorage repositoryAttributeStorage, AssetAttributeStorage assetAttributeStorage, IsAssetAuditable isAssetAuditable) {
        super(deploymentAccess, capabilityRegistry, restClientProvider, clmConnector, ignorePatternsUpdater, repositoryAttributeStorage);
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
        this.isAssetAuditable = (IsAssetAuditable)Preconditions.checkNotNull((Object)isAssetAuditable);
    }

    @Override
    public void ingestAssetAttributes(Asset asset, Map<String, Object> attributes) {
        if (this.isAssetAuditable.test(asset)) {
            String statusName;
            String timestamp = (String)attributes.get("audit.timestamp");
            if (timestamp != null) {
                try {
                    this.assetAttributeStorage.setAuditTimestamp(asset, Long.parseLong(timestamp));
                }
                catch (IllegalArgumentException e) {
                    this.log.debug("Unknown audit timestamp {} for asset {}", new Object[]{timestamp, asset.name(), e});
                }
            }
            if ((statusName = (String)attributes.get("quarantine.status")) != null) {
                try {
                    this.assetAttributeStorage.setQuarantineStatus(asset, QuarantineStatus.valueOf(statusName), null);
                }
                catch (IllegalArgumentException e) {
                    this.log.debug("Unknown quarantine status {} for asset {}", new Object[]{statusName, asset.name(), e});
                }
            }
        }
    }

    @Override
    protected NestedAttributesMap getFirewallAttributes(Repository repository) {
        return ((AttributesFacet)repository.facet(AttributesFacet.class)).getAttributes().child("firewall");
    }

    @Override
    public void recordRepositoryFirewallAttributes(Repository repository, Map<String, Object> iqAttributes) {
        ((AttributesFacet)repository.facet(AttributesFacet.class)).modifyAttributes(change -> this.ingestRepositoryAttributes(repository.getName(), change, iqAttributes));
    }
}

