/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.migration.datastore;

import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsUpdater;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.datastore.AssetAttributeStorage;
import com.sonatype.nexus.clm.internal.datastore.IsAssetAuditable;
import com.sonatype.nexus.clm.internal.migration.AbstractFirewallMigrationHelperImpl;
import com.sonatype.nexus.clm.migration.datastore.DatastoreFirewallMigrationHelper;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.node.DeploymentAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentFacet;

@Named
@Singleton
public class DatastoreFirewallMigrationHelperImpl
extends AbstractFirewallMigrationHelperImpl
implements DatastoreFirewallMigrationHelper {
    private final AssetAttributeStorage assetAttributeStorage;
    private final IsAssetAuditable isAssetAuditable;

    @Inject
    public DatastoreFirewallMigrationHelperImpl(DeploymentAccess deploymentAccess, CapabilityRegistry capabilityRegistry, RestClientProvider restClientProvider, ClmConnector clmConnector, FirewallIgnorePatternsUpdater ignorePatternsUpdater, RepositoryAttributeStorage repositoryAttributeStorage, AssetAttributeStorage assetAttributeStorage, IsAssetAuditable isAssetAuditable) {
        super(deploymentAccess, capabilityRegistry, restClientProvider, clmConnector, ignorePatternsUpdater, repositoryAttributeStorage);
        this.assetAttributeStorage = assetAttributeStorage;
        this.isAssetAuditable = isAssetAuditable;
    }

    @Override
    public void ingestAssetAttributes(Repository repository, Asset asset, Map<String, Object> attributes) {
        if (this.isAssetAuditable.test(repository.getFormat().getValue(), asset)) {
            String statusName;
            String timestamp = (String)attributes.get("audit.timestamp");
            if (timestamp != null) {
                try {
                    this.assetAttributeStorage.setAuditTimestamp(repository, asset, Long.parseLong(timestamp));
                }
                catch (IllegalArgumentException e) {
                    this.log.debug("Unknown audit timestamp {} for asset {}", new Object[]{timestamp, asset.path(), e});
                }
            }
            if ((statusName = (String)attributes.get("quarantine.status")) != null) {
                try {
                    this.assetAttributeStorage.setQuarantineStatus(repository, asset, QuarantineStatus.valueOf(statusName), null);
                }
                catch (IllegalArgumentException e) {
                    this.log.debug("Unknown quarantine status {} for asset {}", new Object[]{statusName, asset.path(), e});
                }
            }
        }
    }

    @Override
    protected NestedAttributesMap getFirewallAttributes(Repository repository) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).attributes("firewall");
    }

    @Override
    public void recordRepositoryFirewallAttributes(Repository repository, Map<String, Object> iqAttributes) {
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        NestedAttributesMap attributes = contentFacet.attributes();
        this.ingestRepositoryAttributes(repository.getName(), attributes, iqAttributes);
        contentFacet.withAttribute("firewall", attributes.get("firewall"));
    }
}

