/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.AttributeUtils;
import com.sonatype.nexus.clm.internal.RepositoryAuditFileWalkerProcessor;
import com.sonatype.nexus.clm.internal.datastore.AssetAttributeStorage;
import com.sonatype.nexus.clm.internal.datastore.IsAssetAuditable;
import com.sonatype.nexus.clm.internal.datastore.RepositoryAuditExecutor;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
public class RepositoryAuditFileWalkerProcessorImpl
extends ComponentSupport
implements RepositoryAuditFileWalkerProcessor {
    private final int batchSize = SystemPropertiesHelper.getInteger((String)"nexus.firewall.audit.batchSize", (int)100);
    private final RepositoryAuditExecutor executor;
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final AssetAttributeStorage assetAttributeStorage;
    private final IsAssetAuditable isAssetAuditable;
    private long start;
    private Long repositoryAuditTimestamp;
    private OffsetDateTime repositoryAuditDateTime;
    private List<Asset> batchedAssets;
    private int fileCount;
    private int componentCount;

    @Inject
    public RepositoryAuditFileWalkerProcessorImpl(RepositoryAuditExecutor executor, RepositoryAttributeStorage repositoryAttributeStorage, AssetAttributeStorage assetAttributeStorage, IsAssetAuditable isAssetAuditable) {
        this.executor = (RepositoryAuditExecutor)((Object)Preconditions.checkNotNull((Object)((Object)executor)));
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
        this.isAssetAuditable = (IsAssetAuditable)Preconditions.checkNotNull((Object)isAssetAuditable);
    }

    private void resetBatch() {
        this.batchedAssets = new ArrayList<Asset>(this.batchSize);
    }

    void beforeWalk(Repository repository, String evalTimestamp) {
        String repoName = repository.getName();
        this.start = System.currentTimeMillis();
        this.repositoryAuditTimestamp = AttributeUtils.tryParse(evalTimestamp, Long::valueOf);
        this.repositoryAuditDateTime = this.repositoryAuditTimestamp == null ? null : OffsetDateTime.ofInstant(Instant.ofEpochMilli(this.repositoryAuditTimestamp), ZoneId.systemDefault());
        this.resetBatch();
        this.log.debug("Walk started for repository: {} timestamp: {}", (Object)repoName, (Object)this.repositoryAuditTimestamp);
    }

    void afterWalk(Repository repository) throws Exception {
        if (!this.batchedAssets.isEmpty()) {
            this.executeEvaluation(repository);
        }
        this.executor.awaitCompletion();
        this.repositoryAttributeStorage.clearAuditTimestamp(repository.getName());
        if (this.log.isDebugEnabled()) {
            long millis = System.currentTimeMillis() - this.start;
            float componentsPerMinute = (float)this.componentCount * 60000.0f / (float)millis;
            this.log.debug("Audit completed for repository {} in {} ms, {} files, {} components audited ({} per minute)", new Object[]{repository.getName(), millis, this.fileCount, this.componentCount, Float.valueOf(componentsPerMinute)});
        }
    }

    @Override
    public void walk(Repository repo, String evalTimestamp) throws Exception {
        this.beforeWalk(repo, evalTimestamp);
        if (this.repositoryAuditTimestamp != null) {
            this.processAssets(repo);
        } else {
            this.log.debug("Skipped audit for repository: {} invalid timestamp: {}", (Object)repo.getName(), (Object)evalTimestamp);
        }
        this.afterWalk(repo);
    }

    private void processAssets(Repository repo) throws Exception {
        ContentFacet content = (ContentFacet)repo.facet(ContentFacet.class);
        Continuation page = content.assets().browse(this.batchSize, null);
        while (!page.isEmpty()) {
            CancelableHelper.checkCancellation();
            for (FluentAsset asset : page) {
                this.processAsset(repo, (Asset)asset);
            }
            page = content.assets().browse(this.batchSize, page.nextContinuationToken());
        }
    }

    protected void processAsset(Repository repository, Asset asset) throws Exception {
        ++this.fileCount;
        if (this.shouldAudit(repository.getFormat().getValue(), asset)) {
            ++this.componentCount;
            this.log.trace("Auditing file {}", (Object)asset.path());
            this.batchedAssets.add(asset);
            if (this.batchedAssets.size() >= this.batchSize) {
                this.executeEvaluation(repository);
            }
        } else {
            this.log.trace("Not auditing file {}", (Object)asset.path());
        }
    }

    private void executeEvaluation(Repository repository) throws Exception {
        CancelableHelper.checkCancellation();
        this.executor.executeEvaluation(this.batchedAssets, repository);
        this.resetBatch();
    }

    private boolean shouldAudit(String format, Asset asset) {
        OffsetDateTime blobUpdatedTime;
        Long assetAuditTimestamp;
        return !(!this.isAssetAuditable.test(format, asset) || (assetAuditTimestamp = this.assetAttributeStorage.getAuditTimestamp(asset)) != null && assetAuditTimestamp >= this.repositoryAuditTimestamp || (blobUpdatedTime = (OffsetDateTime)asset.blob().map(AssetBlob::blobCreated).orElse(null)) != null && !blobUpdatedTime.isBefore(this.repositoryAuditDateTime));
    }
}

