/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.datastore;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.sonatype.nexus.clm.internal.AuditRetryStrategy;
import com.sonatype.nexus.clm.internal.IQErrorManager;
import com.sonatype.nexus.clm.internal.RepositoryAuditThreadPool;
import com.sonatype.nexus.clm.internal.datastore.EvaluationSender;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.scheduling.TaskInterruptedException;

@Named
public class RepositoryAuditExecutor
extends ComponentSupport {
    private final RepositoryAuditThreadPool threadPool;
    private final EvaluationSender evaluationSender;
    private final Provider<AuditRetryStrategy> retryStrategyProvider;
    private final IQErrorManager iqErrorManager;
    private final List<Future<?>> undoneFutures;

    @Inject
    public RepositoryAuditExecutor(RepositoryAuditThreadPool threadPool, EvaluationSender evaluationSender, Provider<AuditRetryStrategy> retryStrategyProvider, IQErrorManager iqErrorManager) {
        this.threadPool = (RepositoryAuditThreadPool)Preconditions.checkNotNull((Object)threadPool);
        this.evaluationSender = (EvaluationSender)((Object)Preconditions.checkNotNull((Object)((Object)evaluationSender)));
        this.retryStrategyProvider = (Provider)Preconditions.checkNotNull(retryStrategyProvider);
        this.iqErrorManager = (IQErrorManager)((Object)Preconditions.checkNotNull((Object)((Object)iqErrorManager)));
        this.undoneFutures = new LinkedList();
    }

    public void executeEvaluation(List<Asset> assets, Repository repository) throws Exception {
        this.checkTasks(false);
        this.undoneFutures.add(this.threadPool.submit(new EvaluationTask(assets, repository)));
    }

    public void cancelEvaluations() {
        for (Future<?> future : this.undoneFutures) {
            future.cancel(true);
        }
        this.undoneFutures.clear();
    }

    public void awaitCompletion() throws Exception {
        this.checkTasks(true);
    }

    private void checkTasks(boolean wait) throws Exception {
        Iterator<Future<?>> it = this.undoneFutures.iterator();
        while (it.hasNext()) {
            Future<?> future = it.next();
            if (!future.isDone() && !wait) continue;
            try {
                future.get();
                it.remove();
            }
            catch (ExecutionException e) {
                this.cancelEvaluations();
                Throwables.propagateIfPossible((Throwable)e.getCause(), Exception.class);
                throw e;
            }
            catch (InterruptedException e) {
                this.cancelEvaluations();
                TaskInterruptedException tie = new TaskInterruptedException(e.toString(), false);
                tie.initCause((Throwable)e);
                throw tie;
            }
        }
    }

    private class EvaluationTask
    implements Callable<Void> {
        private final Repository repository;
        private final List<Asset> assets;

        public EvaluationTask(List<Asset> assets, Repository repository) {
            this.assets = (List)Preconditions.checkNotNull(assets);
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        }

        @Override
        public Void call() throws Exception {
            AuditRetryStrategy retryStrategy = (AuditRetryStrategy)((Object)RepositoryAuditExecutor.this.retryStrategyProvider.get());
            while (true) {
                try {
                    RepositoryAuditExecutor.this.iqErrorManager.reset(this.repository.getName());
                    RepositoryAuditExecutor.this.evaluationSender.sendAuditRequest(this.assets, this.repository, "initial_audit");
                }
                catch (IOException | RuntimeException e) {
                    RepositoryAuditExecutor.this.iqErrorManager.addErrorMessage(this.repository.getName(), e);
                    if (retryStrategy.retryRequest(e)) continue;
                    RepositoryAuditExecutor.this.log.error("Policy evaluation for components failed", (Throwable)e);
                    throw e;
                }
                break;
            }
            return null;
        }
    }
}

