/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationData;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataRequestList;
import com.sonatype.clm.dto.model.policy.RepositoryPolicyEvaluationSummary;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.datastore.AssetAttributeStorage;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;

@Named
public class EvaluationSender
extends ComponentSupport {
    private final RestClientProvider restClientProvider;
    private final AssetAttributeStorage assetAttributeStorage;

    @Inject
    public EvaluationSender(RestClientProvider restClientProvider, AssetAttributeStorage assetAttributeStorage) {
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
    }

    public void sendAuditRequest(Asset asset, Repository repository, String reason) throws IOException {
        this.sendAuditRequest((List<Asset>)ImmutableList.of((Object)asset), repository, reason);
    }

    public void sendAuditRequest(List<Asset> assets, Repository repository, String reason) throws IOException {
        if (assets.isEmpty()) {
            return;
        }
        ContentFacet content = (ContentFacet)repository.facet(ContentFacet.class);
        RepositoryComponentEvaluationDataRequestList requestList = this.newRequestList(repository, assets, reason);
        this.restClientProvider.getRepositoryClient(repository.getName()).evaluateComponents(requestList);
        long timestamp = System.currentTimeMillis();
        for (Asset asset : assets) {
            String evaluatedHash = this.getHashCode(asset);
            Optional storedAsset = content.assets().path(asset.path()).find();
            if (storedAsset.isPresent() && Objects.equals(evaluatedHash, this.getHashCode((Asset)storedAsset.get()))) {
                this.assetAttributeStorage.setAuditTimestamp(repository, (Asset)storedAsset.get(), timestamp);
                continue;
            }
            this.log.debug("Ignored audit evaluation for stale asset {}:{}", (Object)repository.getName(), (Object)asset.path());
        }
    }

    public QuarantineStatus sendQuarantineRequest(Asset asset, Repository repository, String reason) throws IOException {
        RepositoryComponentEvaluationDataRequestList requestList = this.newRequestList(repository, (List<Asset>)ImmutableList.of((Object)asset), reason);
        RepositoryComponentEvaluationDataList resultList = this.restClientProvider.getRepositoryClient(repository.getName()).evaluateComponentWithQuarantine(requestList);
        if (resultList == null || resultList.isEmpty()) {
            return QuarantineStatus.DENY;
        }
        QuarantineStatus quarantineStatus = this.getQuarantineStatus(resultList);
        String evaluatedHash = this.getHashCode(asset);
        long timestamp = System.currentTimeMillis();
        Optional storedAsset = ((ContentFacet)repository.facet(ContentFacet.class)).assets().path(asset.path()).find();
        if (storedAsset.isPresent() && Objects.equals(evaluatedHash, this.getHashCode((Asset)storedAsset.get()))) {
            this.assetAttributeStorage.setQuarantineStatus(repository, (Asset)storedAsset.get(), quarantineStatus, timestamp);
        } else {
            this.log.debug("Ignored quarantine evaluation for stale asset {}:{}", (Object)repository.getName(), (Object)asset.path());
        }
        return quarantineStatus;
    }

    @Nullable
    public String getQuarantineReport(Repository repository) {
        try {
            RepositoryPolicyEvaluationSummary summary = this.restClientProvider.getRepositoryClient(repository.getName()).getPolicyEvaluationSummary();
            String serverUrl = this.restClientProvider.getServerUrl();
            return summary.resolveReportUrl(serverUrl);
        }
        catch (IOException e) {
            this.log.warn("Unable to retrieve IQ report for {} repository", (Object)repository.getName(), (Object)e);
            return null;
        }
    }

    private RepositoryComponentEvaluationDataRequestList newRequestList(Repository repository, List<Asset> assets, String cause) {
        String format = repository.getFormat().getValue();
        RepositoryComponentEvaluationDataRequestList requestList = new RepositoryComponentEvaluationDataRequestList(cause);
        for (Asset asset : assets) {
            requestList.components.add(this.newRequest(format, asset));
        }
        return requestList;
    }

    private RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest newRequest(String format, Asset asset) {
        String hash = this.getHashCode(asset);
        return new RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest(format, asset.path(), hash);
    }

    private QuarantineStatus getQuarantineStatus(RepositoryComponentEvaluationDataList results) {
        return ((RepositoryComponentEvaluationData)results.componentEvalResults.get((int)0)).quarantine ? QuarantineStatus.DENY : QuarantineStatus.ALLOW;
    }

    private String getHashCode(Asset asset) {
        return asset.blob().map(AssetBlob::checksums).map(checksums -> (String)checksums.get(HashAlgorithm.SHA1.name())).orElse(null);
    }
}

