/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationData;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataRequestList;
import com.sonatype.clm.dto.model.policy.RepositoryPolicyEvaluationSummary;
import com.sonatype.clm.dto.model.repository.QuarantinedComponentReport;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.datastore.AssetAttributeStorage;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentFacet;

@Named
public class DatastoreEvaluationSender
extends ComponentSupport {
    private final RestClientProvider restClientProvider;
    private final AssetAttributeStorage assetAttributeStorage;

    @Inject
    public DatastoreEvaluationSender(RestClientProvider restClientProvider, AssetAttributeStorage assetAttributeStorage) {
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
    }

    public void sendAuditRequest(Asset asset, Repository repository, String reason) throws IOException {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)reason);
        this.sendAuditRequest((List<Asset>)ImmutableList.of((Object)asset), repository, reason);
    }

    public void sendAuditRequest(List<Asset> assets, Repository repository, String reason) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)reason);
        if (assets.isEmpty()) {
            return;
        }
        String repositoryFormat = repository.getFormat().getValue();
        RepositoryComponentEvaluationDataRequestList requestList = this.newRequestList(repositoryFormat, assets, reason);
        this.restClientProvider.getRepositoryClient(repository.getName()).evaluateComponents(requestList);
        long timestamp = System.currentTimeMillis();
        for (Asset asset : assets) {
            String evaluatedHash = this.assetAttributeStorage.sha1sum(asset);
            Optional storedAssetOpt = ((ContentFacet)repository.facet(ContentFacet.class)).assets().path(asset.path()).find();
            if (storedAssetOpt.isPresent() && evaluatedHash.equals(this.assetAttributeStorage.sha1sum((Asset)storedAssetOpt.get()))) {
                this.assetAttributeStorage.setAuditTimestamp(repository, (Asset)storedAssetOpt.get(), timestamp);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Ignored audit evaluation for stale asset {}:{}", (Object)repository.getName(), (Object)asset.path());
        }
    }

    public QuarantineStatus sendQuarantineRequest(Asset asset, Repository repository, String reason) throws IOException {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)reason);
        String repositoryFormat = repository.getFormat().getValue();
        RepositoryComponentEvaluationDataRequestList requestList = this.newRequestList(repositoryFormat, (List<Asset>)ImmutableList.of((Object)asset), reason);
        RepositoryComponentEvaluationDataList resultList = this.restClientProvider.getRepositoryClient(repository.getName()).evaluateComponentWithQuarantine(requestList);
        if (resultList == null || resultList.isEmpty()) {
            return QuarantineStatus.DENY;
        }
        QuarantineStatus quarantineStatus = this.getQuarantineStatus(resultList);
        String evaluatedHash = this.assetAttributeStorage.sha1sum(asset);
        long timestamp = System.currentTimeMillis();
        Optional storedAssetOpt = ((ContentFacet)repository.facet(ContentFacet.class)).assets().path(asset.path()).find();
        if (storedAssetOpt.isPresent() && evaluatedHash.equals(this.assetAttributeStorage.sha1sum((Asset)storedAssetOpt.get()))) {
            this.assetAttributeStorage.setQuarantineStatus(repository, (Asset)storedAssetOpt.get(), quarantineStatus, timestamp);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Ignored quarantine evaluation for stale asset {}:{}", (Object)repository.getName(), (Object)asset.path());
        }
        return quarantineStatus;
    }

    @Nullable
    public String getQuarantineReport(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        try {
            RepositoryPolicyEvaluationSummary summary = this.restClientProvider.getRepositoryClient(repository.getName()).getPolicyEvaluationSummary();
            String serverUrl = this.restClientProvider.getServerUrl();
            return summary.resolveReportUrl(serverUrl);
        }
        catch (IOException e) {
            this.log.warn("Unable to retrieve the link to IQ Repository Results View for {} repository", (Object)repository.getName(), (Object)e);
            return null;
        }
    }

    @Nullable
    public String getQuarantinedComponentReport(Repository repository, Asset asset) {
        try {
            QuarantinedComponentReport quarantinedComponentReport = this.restClientProvider.getRepositoryClient(repository.getName()).getQuarantinedComponentReport(asset.path());
            String serverUrl = this.restClientProvider.getServerUrl();
            return quarantinedComponentReport.resolveReportUrl(serverUrl);
        }
        catch (IOException e) {
            this.log.warn("Unable to retrieve the link to IQ Quarantined Component View for asset {}:{}", new Object[]{repository.getName(), asset.path(), e});
            return null;
        }
    }

    private RepositoryComponentEvaluationDataRequestList newRequestList(String repositoryFormat, List<Asset> assets, String cause) {
        RepositoryComponentEvaluationDataRequestList requestList = new RepositoryComponentEvaluationDataRequestList(cause);
        for (Asset asset : assets) {
            requestList.components.add(this.newRequest(repositoryFormat, asset));
        }
        return requestList;
    }

    private RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest newRequest(String repositoryFormat, Asset asset) {
        String hash = this.assetAttributeStorage.sha1sum(asset);
        return new RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest(repositoryFormat, asset.path(), hash);
    }

    private QuarantineStatus getQuarantineStatus(RepositoryComponentEvaluationDataList results) {
        return ((RepositoryComponentEvaluationData)results.componentEvalResults.get((int)0)).quarantine ? QuarantineStatus.DENY : QuarantineStatus.ALLOW;
    }
}

