/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.datastore;

import com.sonatype.nexus.clm.internal.AttributeUtils;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;

@Named
@Singleton
public class AssetAttributeStorage
extends ComponentSupport {
    public static final String ASSET_AUDIT_TIMESTAMP_KEY = "auditAssetTimestamp";
    public static final String ASSET_EVALUATED_HASH_KEY = "evaluated-hash";
    public static final String ASSET_QUARANTINE_STATUS_KEY = "quarantine-status";

    public void setAuditTimestamp(Repository repository, Asset asset, long timestamp) {
        HashMap<String, String> firewall = new HashMap<String, String>();
        firewall.put(ASSET_AUDIT_TIMESTAMP_KEY, Long.toString(timestamp));
        firewall.put(ASSET_EVALUATED_HASH_KEY, Objects.toString(this.sha1sum(asset), null));
        ((ContentFacet)repository.facet(ContentFacet.class)).assets().with(asset).withAttribute("firewall", firewall);
    }

    @Nullable
    public Long getAuditTimestamp(Asset asset) {
        if (Objects.equals(this.sha1sum(asset), this.getEvaluatedHash(asset))) {
            return AttributeUtils.tryParse(this.getAttribute(asset, ASSET_AUDIT_TIMESTAMP_KEY), Long::valueOf);
        }
        return null;
    }

    @Nullable
    public Long reloadAuditTimestamp(Repository repository, Asset asset) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).assets().path(asset.path()).find().filter(storedAsset -> Objects.equals(this.sha1sum(asset), this.sha1sum((Asset)storedAsset))).map(this::getAuditTimestamp).orElse(null);
    }

    public void setQuarantineStatus(Repository repository, Asset asset, QuarantineStatus status, @Nullable Long timestamp) {
        NestedAttributesMap attributes = this.getFirewallAttributes(asset);
        attributes.set(ASSET_QUARANTINE_STATUS_KEY, (Object)status.name());
        attributes.set(ASSET_EVALUATED_HASH_KEY, (Object)Objects.toString(this.sha1sum(asset), null));
        if (timestamp != null) {
            attributes.set(ASSET_AUDIT_TIMESTAMP_KEY, (Object)timestamp.toString());
        }
        ((ContentFacet)repository.facet(ContentFacet.class)).assets().with(asset).withAttribute("firewall", (Object)attributes.backing());
    }

    @Nullable
    public QuarantineStatus getQuarantineStatus(Asset asset) {
        if (Objects.equals(this.sha1sum(asset), this.getEvaluatedHash(asset))) {
            return AttributeUtils.tryParse(this.getAttribute(asset, ASSET_QUARANTINE_STATUS_KEY), QuarantineStatus::valueOf);
        }
        return null;
    }

    @Nullable
    public QuarantineStatus reloadQuarantineStatus(Repository repository, Asset asset) {
        Optional storedAssetOpt = ((ContentFacet)repository.facet(ContentFacet.class)).assets().path(asset.path()).find();
        if (storedAssetOpt.isPresent() && Objects.equals(this.sha1sum(asset), this.sha1sum((Asset)storedAssetOpt.get()))) {
            return this.getQuarantineStatus((Asset)storedAssetOpt.get());
        }
        return null;
    }

    @Nullable
    public String getEvaluatedHash(Asset asset) {
        return this.getAttribute(asset, ASSET_EVALUATED_HASH_KEY);
    }

    private String getAttribute(Asset asset, String key) {
        return (String)this.getFirewallAttributes(asset).get(key, String.class);
    }

    private NestedAttributesMap getFirewallAttributes(Asset asset) {
        return asset.attributes().child("firewall");
    }

    public String sha1sum(Asset asset) {
        return asset.blob().map(AssetBlob::checksums).map(checksums -> (String)checksums.get(HashAlgorithm.SHA1.name())).orElse(null);
    }
}

