/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.capability;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.FirewallAuditCapabilityConfiguration;
import com.sonatype.nexus.clm.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsTaskManager;
import com.sonatype.nexus.clm.internal.FirewallTaskManager;
import com.sonatype.nexus.clm.internal.IQErrorManager;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.condition.NexusConditions;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.capability.RepositoryConditions;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named(value="firewall.audit")
public class FirewallAuditCapability
extends CapabilitySupport<FirewallAuditCapabilityConfiguration> {
    private static final String NPM_FORMAT_NAME = "npm";
    private static final String REMOVE_QUARANTINED_KEY = "removeQuarantinedVersions";
    private final RepositoryManager repositoryManager;
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final FirewallIgnorePatternsTaskManager firewallIgnorePatternsTaskManager;
    private final FirewallTaskManager firewallTaskManager;
    private final Condition nexusActiveCondition;
    private final RepositoryConditions repositoryConditions;
    private final IQErrorManager iqErrorManager;
    private final ClmConnector clmConnector;
    private String currentRepositoryName;

    @Inject
    public FirewallAuditCapability(RepositoryManager repositoryManager, RepositoryAttributeStorage repositoryAttributeStorage, FirewallIgnorePatternsTaskManager firewallIgnorePatternsTaskManager, FirewallTaskManager firewallTaskManager, NexusConditions nexusConditions, RepositoryConditions repositoryConditions, IQErrorManager iqErrorManager, ClmConnector clmConnector) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.firewallIgnorePatternsTaskManager = (FirewallIgnorePatternsTaskManager)((Object)Preconditions.checkNotNull((Object)((Object)firewallIgnorePatternsTaskManager)));
        this.firewallTaskManager = (FirewallTaskManager)((Object)Preconditions.checkNotNull((Object)((Object)firewallTaskManager)));
        this.nexusActiveCondition = ((NexusConditions)Preconditions.checkNotNull((Object)nexusConditions)).active();
        this.repositoryConditions = (RepositoryConditions)Preconditions.checkNotNull((Object)repositoryConditions);
        this.iqErrorManager = (IQErrorManager)((Object)Preconditions.checkNotNull((Object)((Object)iqErrorManager)));
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
    }

    protected FirewallAuditCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new FirewallAuditCapabilityConfiguration(properties);
    }

    protected void onCreate(FirewallAuditCapabilityConfiguration config) throws Exception {
        super.onCreate((Object)config);
        String repositoryName = config.getRepositoryName();
        this.log.debug("Create auditing capability on repository: {}", (Object)repositoryName);
        if (!EventHelper.isReplicating()) {
            this.repositoryAttributeStorage.setAuditEnabled(repositoryName, false);
        }
    }

    protected void onActivate(FirewallAuditCapabilityConfiguration config) throws Exception {
        String repositoryName = config.getRepositoryName();
        this.log.info("Activate auditing capability on repository: {}", (Object)repositoryName);
        this.currentRepositoryName = repositoryName;
        if (!EventHelper.isReplicating()) {
            this.firewallIgnorePatternsTaskManager.startPeriodically();
            this.repositoryAttributeStorage.setAuditEnabled(repositoryName, true);
            boolean quarantineEnabled = config.isQuarantineEnabled();
            this.log.info("{} quarantine on repository: {}", (Object)(quarantineEnabled ? "Enable" : "Disable"), (Object)repositoryName);
            this.repositoryAttributeStorage.setQuarantineEnabled(repositoryName, quarantineEnabled);
            if (this.repositoryAttributeStorage.hasErrors()) {
                this.log.warn("Skipped verifying IQ connection for the {} repository due to errors on other repositories", (Object)repositoryName);
                this.iqErrorManager.addErrorMessage(repositoryName);
                return;
            }
            this.iqErrorManager.verifyConnection(repositoryName);
            Long auditTimestamp = this.repositoryAttributeStorage.getAuditTimestamp(repositoryName);
            if (auditTimestamp != null) {
                this.firewallTaskManager.startAudit(repositoryName, auditTimestamp.toString());
            }
        }
    }

    private boolean isRepositoryOnline(String repositoryName) {
        if (this.repositoryManager.exists(repositoryName)) {
            return this.repositoryManager.get(repositoryName).getConfiguration().isOnline();
        }
        return false;
    }

    protected void onPassivate(FirewallAuditCapabilityConfiguration config) throws Exception {
        String repositoryName = config.getRepositoryName();
        this.log.info("Deactivating auditing capability on repository: {}, Nexus Active: {}", (Object)repositoryName, (Object)this.nexusActiveCondition.isSatisfied());
        if (!EventHelper.isReplicating() && this.nexusActiveCondition.isSatisfied() && this.isRepositoryOnline(repositoryName)) {
            this.firewallTaskManager.stopAudit(repositoryName);
            this.repositoryAttributeStorage.setAuditEnabled(repositoryName, false);
            this.iqErrorManager.verifyConnection(repositoryName);
            this.disableNpmRelatedConfigurations(repositoryName);
        }
    }

    protected void onUpdate(FirewallAuditCapabilityConfiguration config) throws Exception {
        if (!this.context().isActive()) {
            return;
        }
        String repositoryName = config.getRepositoryName();
        if (this.currentRepositoryName.equals(config.getRepositoryName())) {
            super.onUpdate((Object)config);
            boolean quarantineEnabled = config.isQuarantineEnabled();
            this.log.info("{} quarantine on repository: {}", (Object)(quarantineEnabled ? "Enable" : "Disable"), (Object)repositoryName);
            this.repositoryAttributeStorage.setQuarantineEnabled(repositoryName, quarantineEnabled);
            this.iqErrorManager.verifyConnection(repositoryName);
            if (!quarantineEnabled) {
                this.disableNpmRelatedConfigurations(repositoryName);
            }
        } else {
            this.onPassivate(new FirewallAuditCapabilityConfiguration(config.asMap()).withRepositoryName(this.currentRepositoryName));
            super.onUpdate((Object)config);
            this.onActivate(config);
        }
    }

    protected void onRemove(FirewallAuditCapabilityConfiguration config) throws Exception {
        String repositoryName = config.getRepositoryName();
        this.log.debug("Remove auditing capability on repository: {}", (Object)repositoryName);
        if (!EventHelper.isReplicating()) {
            this.repositoryAttributeStorage.clearAttributes(repositoryName);
            this.disableNpmRelatedConfigurations(repositoryName);
        }
    }

    public Condition activationCondition() {
        return this.repositoryConditions.repositoryIsOnline(() -> this.isConfigured() ? ((FirewallAuditCapabilityConfiguration)((Object)((Object)this.getConfig()))).getRepositoryName() : null);
    }

    public Condition validityCondition() {
        return this.repositoryConditions.repositoryExists(() -> this.isConfigured() ? ((FirewallAuditCapabilityConfiguration)((Object)((Object)this.getConfig()))).getRepositoryName() : null);
    }

    protected String renderDescription() {
        String repositoryName = ((FirewallAuditCapabilityConfiguration)((Object)this.getConfig())).getRepositoryName();
        TemplateParameters model = new TemplateParameters();
        Repository repo = this.repositoryManager.get(repositoryName);
        if (repo != null) {
            model.set("repository", (Object)repositoryName);
        } else {
            this.log.debug("unable to render description properly: {} repository not found", (Object)repositoryName);
            model.set("repository", (Object)repositoryName);
        }
        return this.render("firewall.audit-description.vm", model);
    }

    protected String renderStatus() throws Exception {
        if (!this.context().isActive()) {
            return null;
        }
        try {
            String error;
            String repositoryName = ((FirewallAuditCapabilityConfiguration)((Object)this.getConfig())).getRepositoryName();
            TemplateParameters model = this.clmConnector.getConfiguration() == null ? this.getMessageModel("Connection to IQ Server is not configured.") : (!this.repositoryAttributeStorage.isAuditEnabled(repositoryName) ? this.getMessageModel("Audit is currently disabled.") : (this.firewallTaskManager.isAuditRunning(repositoryName) ? this.getMessageModel("Audit is currently running against the repository.") : this.getMessageModel((error = this.iqErrorManager.getErrorMessage(repositoryName)) != null ? error : "Audit is active for the repository.")));
            return this.render("firewall.audit-status.vm", model);
        }
        catch (Exception e) {
            return this.renderFailure(e);
        }
    }

    private void disableNpmRelatedConfigurations(String repositoryName) throws Exception {
        Repository repository = this.repositoryManager.get(repositoryName);
        assert (repository != null);
        if (NPM_FORMAT_NAME.equals(repository.getFormat().getValue())) {
            Configuration configuration = repository.getConfiguration();
            configuration.attributes(NPM_FORMAT_NAME).set(REMOVE_QUARANTINED_KEY, (Object)false);
            this.repositoryManager.update(configuration);
        }
    }

    private TemplateParameters getMessageModel(String message) {
        return new TemplateParameters().set("message", (Object)message);
    }

    @VisibleForTesting
    String getCurrentRepositoryName() {
        return this.currentRepositoryName;
    }
}

