/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.capability;

import com.google.common.collect.Lists;
import com.sonatype.nexus.clm.ClmConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.formfields.PasswordFormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.formfields.TextAreaFormField;
import org.sonatype.nexus.formfields.UrlFormField;

@AvailabilityVersion(from="1.0")
@Named(value="clm")
@Singleton
public class ClmCapabilityDescriptor
extends CapabilityDescriptorSupport<ClmConfiguration>
implements Taggable {
    public static final String TYPE_ID = "clm";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"clm");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields;

    public ClmCapabilityDescriptor() {
        this.setExposed(false);
        this.setHidden(true);
        this.formFields = Lists.newArrayList((Object[])new FormField[]{new UrlFormField("url", messages.urlLabel(), messages.urlHelp(), true), new CheckboxFormField("useTrustStore", messages.useTrustStoreLabel(), null, false), new ComboboxFormField("authenticationType", messages.authenticationTypeLabel(), null, true).withStoreApi("clm_CLM.authTypes").withIdMapping("type").withNameMapping("description"), new StringTextFormField("username", messages.usernameLabel(), messages.usernameHelp(), false), new PasswordFormField("password", messages.passwordLabel(), messages.passwordHelp(), false), new NumberTextFormField("timeout", messages.timeoutLabel(), messages.timeoutHelp(), false), new TextAreaFormField("properties", messages.propertiesLabel(), messages.propertiesHelp(), false)});
    }

    protected ClmConfiguration createConfig(Map<String, String> properties) {
        return new ClmConfiguration(properties);
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    protected String renderAbout() throws Exception {
        return this.render("clm-about.vm");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Firewall")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Firewall Configuration")
        public String name();

        @MessageBundle.DefaultMessage(value="URL")
        public String urlLabel();

        @MessageBundle.DefaultMessage(value="The address of your Firewall")
        public String urlHelp();

        @MessageBundle.DefaultMessage(value="Use the Nexus Repository truststore")
        public String useTrustStoreLabel();

        @MessageBundle.DefaultMessage(value="Authentication Method")
        public String authenticationTypeLabel();

        @MessageBundle.DefaultMessage(value="Username")
        public String usernameLabel();

        @MessageBundle.DefaultMessage(value="User with access to Firewall")
        public String usernameHelp();

        @MessageBundle.DefaultMessage(value="Password")
        public String passwordLabel();

        @MessageBundle.DefaultMessage(value="Credentials for the Firewall user")
        public String passwordHelp();

        @MessageBundle.DefaultMessage(value="Request Timeout")
        public String timeoutLabel();

        @MessageBundle.DefaultMessage(value="Seconds to wait for activity before stopping and retrying the connection. Leave blank to use the globally defined HTTP timeout")
        public String timeoutHelp();

        @MessageBundle.DefaultMessage(value="Properties")
        public String propertiesLabel();

        @MessageBundle.DefaultMessage(value="Additional properties to configure for Firewall")
        public String propertiesHelp();
    }
}

