/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.sonatype.nexus.clm.internal.StorageExceptionChecker;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.client.HttpResponseException;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class RetryWhitelist
extends ComponentSupport {
    private final Set<Integer> statusCodeWhitelist = ImmutableSet.of((Object)502, (Object)503, (Object)504, (Object)401, (Object)403, (Object)402, (Object[])new Integer[0]);
    private final StorageExceptionChecker exceptionChecker;

    @Inject
    public RetryWhitelist(StorageExceptionChecker exceptionChecker) {
        this.exceptionChecker = (StorageExceptionChecker)Preconditions.checkNotNull((Object)exceptionChecker);
    }

    public boolean doRetry(Exception exception) {
        int statusCode;
        if (exception instanceof HttpResponseException && !this.statusCodeWhitelist.contains(statusCode = ((HttpResponseException)exception).getStatusCode())) {
            this.log.debug("Retry statusCode={} doRetry=false", (Object)statusCode);
            return false;
        }
        if (this.exceptionChecker.isRetryException(exception)) {
            return true;
        }
        return exception instanceof IOException;
    }
}

