/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
public class FirewallTaskManager
extends ComponentSupport {
    private final TaskScheduler taskScheduler;

    @Inject
    public FirewallTaskManager(TaskScheduler taskScheduler) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    public void startAudit(String repositoryName, String timestamp) {
        List<TaskInfo> existingTasks;
        Map<Boolean, List<TaskInfo>> partitions = this.partitionByTimestamp(this.getAuditTasks(repositoryName), timestamp);
        List<TaskInfo> obsoleteTasks = partitions.get(false);
        if (obsoleteTasks != null) {
            obsoleteTasks.forEach(this::removeTask);
        }
        if ((existingTasks = partitions.get(true)) == null || existingTasks.isEmpty()) {
            this.scheduleTask(repositoryName, timestamp);
            this.removeDuplicates(repositoryName, timestamp);
        } else {
            TaskInfo taskInfo = existingTasks.get(0);
            this.log.debug("Already scheduled task '{}' ({})", (Object)taskInfo.getName(), (Object)taskInfo.getId());
        }
    }

    private void removeDuplicates(String repositoryName, String timestamp) {
        List<TaskInfo> existingTasks = this.partitionByTimestamp(this.getAuditTasks(repositoryName), timestamp).get(true);
        existingTasks.stream().sorted(Comparator.comparing(TaskInfo::getId)).skip(1L).forEach(this::removeTask);
    }

    private Map<Boolean, List<TaskInfo>> partitionByTimestamp(Stream<TaskInfo> taskInfos, String timestamp) {
        return taskInfos.collect(Collectors.partitioningBy(taskInfo -> timestamp.equals(taskInfo.getConfiguration().getString("auditTimestamp"))));
    }

    public void stopAudit(String repositoryName) {
        this.getAuditTasks(repositoryName).forEach(this::removeTask);
    }

    public boolean isAuditRunning(String repositoryName) {
        return this.getAuditTasks(repositoryName).findAny().isPresent();
    }

    private void scheduleTask(String repositoryName, String timestamp) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("firewall.audit");
        configuration.setString("repositoryName", repositoryName);
        configuration.setString("auditTimestamp", timestamp);
        configuration.setName("Repository Audit: " + repositoryName);
        Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(System.currentTimeMillis() + 5L), "*/5 * * ? * *");
        TaskInfo taskInfo = this.taskScheduler.scheduleTask(configuration, (Schedule)schedule);
        this.log.debug("Scheduled task '{}' ({})", (Object)taskInfo.getName(), (Object)taskInfo.getId());
    }

    private void removeTask(TaskInfo taskInfo) {
        boolean removed = taskInfo.remove();
        this.log.debug("Removed task '{}' ({}): {}", new Object[]{taskInfo.getName(), taskInfo.getId(), removed});
    }

    private Stream<TaskInfo> getAuditTasks(String repositoryName) {
        return this.taskScheduler.listsTasks().stream().filter(taskInfo -> this.isAuditTaskForRepository((TaskInfo)taskInfo, repositoryName));
    }

    private boolean isAuditTaskForRepository(TaskInfo taskInfo, String repositoryName) {
        TaskConfiguration taskConfig = taskInfo.getConfiguration();
        return "firewall.audit".equals(taskConfig.getTypeId()) && Objects.equals(repositoryName, taskConfig.getString("repositoryName"));
    }
}

